/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.orderdrafts.cargo.requests;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OrderDraftAssociateCargoWithTaskReq {
    private final String orderId;
    private final String taskId;
    private final String cargoId;
    private final Map<String, Object> additionalProperties;

    private OrderDraftAssociateCargoWithTaskReq(String orderId, String taskId, String cargoId, Map<String, Object> additionalProperties) {
        this.orderId = orderId;
        this.taskId = taskId;
        this.cargoId = cargoId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="order_id")
    public String getOrderId() {
        return this.orderId;
    }

    @JsonProperty(value="task_id")
    public String getTaskId() {
        return this.taskId;
    }

    @JsonProperty(value="cargo_id")
    public String getCargoId() {
        return this.cargoId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OrderDraftAssociateCargoWithTaskReq && this.equalTo((OrderDraftAssociateCargoWithTaskReq)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderDraftAssociateCargoWithTaskReq other) {
        return this.orderId.equals(other.orderId) && this.taskId.equals(other.taskId) && this.cargoId.equals(other.cargoId);
    }

    public int hashCode() {
        return Objects.hash(this.orderId, this.taskId, this.cargoId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OrderIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OrderIdStage,
    TaskIdStage,
    CargoIdStage,
    _FinalStage {
        private String orderId;
        private String taskId;
        private String cargoId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(OrderDraftAssociateCargoWithTaskReq other) {
            this.orderId(other.getOrderId());
            this.taskId(other.getTaskId());
            this.cargoId(other.getCargoId());
            return this;
        }

        @Override
        @JsonSetter(value="order_id")
        public TaskIdStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="task_id")
        public CargoIdStage taskId(@NotNull String taskId) {
            this.taskId = Objects.requireNonNull(taskId, "taskId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="cargo_id")
        public _FinalStage cargoId(@NotNull String cargoId) {
            this.cargoId = Objects.requireNonNull(cargoId, "cargoId must not be null");
            return this;
        }

        @Override
        public OrderDraftAssociateCargoWithTaskReq build() {
            return new OrderDraftAssociateCargoWithTaskReq(this.orderId, this.taskId, this.cargoId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public OrderDraftAssociateCargoWithTaskReq build();
    }

    public static interface CargoIdStage {
        public _FinalStage cargoId(@NotNull String var1);
    }

    public static interface TaskIdStage {
        public CargoIdStage taskId(@NotNull String var1);
    }

    public static interface OrderIdStage {
        public TaskIdStage orderId(@NotNull String var1);

        public Builder from(OrderDraftAssociateCargoWithTaskReq var1);
    }
}

