/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.orderdrafts.expanded.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.resources.orderdrafts.expanded.types.ExpandedListV1RequestSortOrder;
import com.chrt.api.types.OrderAndTaskGroupExpandedReq;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ExpandedListV1Request {
    private final Optional<String> sortBy;
    private final Optional<ExpandedListV1RequestSortOrder> sortOrder;
    private final Optional<Integer> page;
    private final Optional<Integer> pageSize;
    private final Optional<OffsetDateTime> filterDraftStartedAtTimestampLte;
    private final Optional<OffsetDateTime> filterDraftStartedAtTimestampGte;
    private final OrderAndTaskGroupExpandedReq body;
    private final Map<String, Object> additionalProperties;

    private ExpandedListV1Request(Optional<String> sortBy, Optional<ExpandedListV1RequestSortOrder> sortOrder, Optional<Integer> page, Optional<Integer> pageSize, Optional<OffsetDateTime> filterDraftStartedAtTimestampLte, Optional<OffsetDateTime> filterDraftStartedAtTimestampGte, OrderAndTaskGroupExpandedReq body, Map<String, Object> additionalProperties) {
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.page = page;
        this.pageSize = pageSize;
        this.filterDraftStartedAtTimestampLte = filterDraftStartedAtTimestampLte;
        this.filterDraftStartedAtTimestampGte = filterDraftStartedAtTimestampGte;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getSortBy() {
        if (this.sortBy == null) {
            return Optional.empty();
        }
        return this.sortBy;
    }

    @JsonIgnore
    public Optional<ExpandedListV1RequestSortOrder> getSortOrder() {
        if (this.sortOrder == null) {
            return Optional.empty();
        }
        return this.sortOrder;
    }

    @JsonIgnore
    public Optional<Integer> getPage() {
        if (this.page == null) {
            return Optional.empty();
        }
        return this.page;
    }

    @JsonIgnore
    public Optional<Integer> getPageSize() {
        if (this.pageSize == null) {
            return Optional.empty();
        }
        return this.pageSize;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterDraftStartedAtTimestampLte() {
        if (this.filterDraftStartedAtTimestampLte == null) {
            return Optional.empty();
        }
        return this.filterDraftStartedAtTimestampLte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterDraftStartedAtTimestampGte() {
        if (this.filterDraftStartedAtTimestampGte == null) {
            return Optional.empty();
        }
        return this.filterDraftStartedAtTimestampGte;
    }

    @JsonProperty(value="body")
    public OrderAndTaskGroupExpandedReq getBody() {
        return this.body;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sort_by")
    private Optional<String> _getSortBy() {
        return this.sortBy;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sort_order")
    private Optional<ExpandedListV1RequestSortOrder> _getSortOrder() {
        return this.sortOrder;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="page")
    private Optional<Integer> _getPage() {
        return this.page;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="page_size")
    private Optional<Integer> _getPageSize() {
        return this.pageSize;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="filter_draft_started_at_timestamp_lte")
    private Optional<OffsetDateTime> _getFilterDraftStartedAtTimestampLte() {
        return this.filterDraftStartedAtTimestampLte;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="filter_draft_started_at_timestamp_gte")
    private Optional<OffsetDateTime> _getFilterDraftStartedAtTimestampGte() {
        return this.filterDraftStartedAtTimestampGte;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ExpandedListV1Request && this.equalTo((ExpandedListV1Request)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ExpandedListV1Request other) {
        return this.sortBy.equals(other.sortBy) && this.sortOrder.equals(other.sortOrder) && this.page.equals(other.page) && this.pageSize.equals(other.pageSize) && this.filterDraftStartedAtTimestampLte.equals(other.filterDraftStartedAtTimestampLte) && this.filterDraftStartedAtTimestampGte.equals(other.filterDraftStartedAtTimestampGte) && this.body.equals(other.body);
    }

    public int hashCode() {
        return Objects.hash(this.sortBy, this.sortOrder, this.page, this.pageSize, this.filterDraftStartedAtTimestampLte, this.filterDraftStartedAtTimestampGte, this.body);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BodyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements BodyStage,
    _FinalStage {
        private OrderAndTaskGroupExpandedReq body;
        private Optional<OffsetDateTime> filterDraftStartedAtTimestampGte = Optional.empty();
        private Optional<OffsetDateTime> filterDraftStartedAtTimestampLte = Optional.empty();
        private Optional<Integer> pageSize = Optional.empty();
        private Optional<Integer> page = Optional.empty();
        private Optional<ExpandedListV1RequestSortOrder> sortOrder = Optional.empty();
        private Optional<String> sortBy = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ExpandedListV1Request other) {
            this.sortBy(other.getSortBy());
            this.sortOrder(other.getSortOrder());
            this.page(other.getPage());
            this.pageSize(other.getPageSize());
            this.filterDraftStartedAtTimestampLte(other.getFilterDraftStartedAtTimestampLte());
            this.filterDraftStartedAtTimestampGte(other.getFilterDraftStartedAtTimestampGte());
            this.body(other.getBody());
            return this;
        }

        @Override
        @JsonSetter(value="body")
        public _FinalStage body(@NotNull OrderAndTaskGroupExpandedReq body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @Override
        public _FinalStage filterDraftStartedAtTimestampGte(Nullable<OffsetDateTime> filterDraftStartedAtTimestampGte) {
            this.filterDraftStartedAtTimestampGte = filterDraftStartedAtTimestampGte.isNull() ? null : (filterDraftStartedAtTimestampGte.isEmpty() ? Optional.empty() : Optional.of(filterDraftStartedAtTimestampGte.get()));
            return this;
        }

        @Override
        public _FinalStage filterDraftStartedAtTimestampGte(OffsetDateTime filterDraftStartedAtTimestampGte) {
            this.filterDraftStartedAtTimestampGte = Optional.ofNullable(filterDraftStartedAtTimestampGte);
            return this;
        }

        @Override
        @JsonSetter(value="filter_draft_started_at_timestamp_gte", nulls=Nulls.SKIP)
        public _FinalStage filterDraftStartedAtTimestampGte(Optional<OffsetDateTime> filterDraftStartedAtTimestampGte) {
            this.filterDraftStartedAtTimestampGte = filterDraftStartedAtTimestampGte;
            return this;
        }

        @Override
        public _FinalStage filterDraftStartedAtTimestampLte(Nullable<OffsetDateTime> filterDraftStartedAtTimestampLte) {
            this.filterDraftStartedAtTimestampLte = filterDraftStartedAtTimestampLte.isNull() ? null : (filterDraftStartedAtTimestampLte.isEmpty() ? Optional.empty() : Optional.of(filterDraftStartedAtTimestampLte.get()));
            return this;
        }

        @Override
        public _FinalStage filterDraftStartedAtTimestampLte(OffsetDateTime filterDraftStartedAtTimestampLte) {
            this.filterDraftStartedAtTimestampLte = Optional.ofNullable(filterDraftStartedAtTimestampLte);
            return this;
        }

        @Override
        @JsonSetter(value="filter_draft_started_at_timestamp_lte", nulls=Nulls.SKIP)
        public _FinalStage filterDraftStartedAtTimestampLte(Optional<OffsetDateTime> filterDraftStartedAtTimestampLte) {
            this.filterDraftStartedAtTimestampLte = filterDraftStartedAtTimestampLte;
            return this;
        }

        @Override
        public _FinalStage pageSize(Nullable<Integer> pageSize) {
            this.pageSize = pageSize.isNull() ? null : (pageSize.isEmpty() ? Optional.empty() : Optional.of(pageSize.get()));
            return this;
        }

        @Override
        public _FinalStage pageSize(Integer pageSize) {
            this.pageSize = Optional.ofNullable(pageSize);
            return this;
        }

        @Override
        @JsonSetter(value="page_size", nulls=Nulls.SKIP)
        public _FinalStage pageSize(Optional<Integer> pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Override
        public _FinalStage page(Nullable<Integer> page) {
            this.page = page.isNull() ? null : (page.isEmpty() ? Optional.empty() : Optional.of(page.get()));
            return this;
        }

        @Override
        public _FinalStage page(Integer page) {
            this.page = Optional.ofNullable(page);
            return this;
        }

        @Override
        @JsonSetter(value="page", nulls=Nulls.SKIP)
        public _FinalStage page(Optional<Integer> page) {
            this.page = page;
            return this;
        }

        @Override
        public _FinalStage sortOrder(Nullable<ExpandedListV1RequestSortOrder> sortOrder) {
            this.sortOrder = sortOrder.isNull() ? null : (sortOrder.isEmpty() ? Optional.empty() : Optional.of(sortOrder.get()));
            return this;
        }

        @Override
        public _FinalStage sortOrder(ExpandedListV1RequestSortOrder sortOrder) {
            this.sortOrder = Optional.ofNullable(sortOrder);
            return this;
        }

        @Override
        @JsonSetter(value="sort_order", nulls=Nulls.SKIP)
        public _FinalStage sortOrder(Optional<ExpandedListV1RequestSortOrder> sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public _FinalStage sortBy(Nullable<String> sortBy) {
            this.sortBy = sortBy.isNull() ? null : (sortBy.isEmpty() ? Optional.empty() : Optional.of(sortBy.get()));
            return this;
        }

        @Override
        public _FinalStage sortBy(String sortBy) {
            this.sortBy = Optional.ofNullable(sortBy);
            return this;
        }

        @Override
        @JsonSetter(value="sort_by", nulls=Nulls.SKIP)
        public _FinalStage sortBy(Optional<String> sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public ExpandedListV1Request build() {
            return new ExpandedListV1Request(this.sortBy, this.sortOrder, this.page, this.pageSize, this.filterDraftStartedAtTimestampLte, this.filterDraftStartedAtTimestampGte, this.body, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ExpandedListV1Request build();

        public _FinalStage sortBy(Optional<String> var1);

        public _FinalStage sortBy(String var1);

        public _FinalStage sortBy(Nullable<String> var1);

        public _FinalStage sortOrder(Optional<ExpandedListV1RequestSortOrder> var1);

        public _FinalStage sortOrder(ExpandedListV1RequestSortOrder var1);

        public _FinalStage sortOrder(Nullable<ExpandedListV1RequestSortOrder> var1);

        public _FinalStage page(Optional<Integer> var1);

        public _FinalStage page(Integer var1);

        public _FinalStage page(Nullable<Integer> var1);

        public _FinalStage pageSize(Optional<Integer> var1);

        public _FinalStage pageSize(Integer var1);

        public _FinalStage pageSize(Nullable<Integer> var1);

        public _FinalStage filterDraftStartedAtTimestampLte(Optional<OffsetDateTime> var1);

        public _FinalStage filterDraftStartedAtTimestampLte(OffsetDateTime var1);

        public _FinalStage filterDraftStartedAtTimestampLte(Nullable<OffsetDateTime> var1);

        public _FinalStage filterDraftStartedAtTimestampGte(Optional<OffsetDateTime> var1);

        public _FinalStage filterDraftStartedAtTimestampGte(OffsetDateTime var1);

        public _FinalStage filterDraftStartedAtTimestampGte(Nullable<OffsetDateTime> var1);
    }

    public static interface BodyStage {
        public _FinalStage body(@NotNull OrderAndTaskGroupExpandedReq var1);

        public Builder from(ExpandedListV1Request var1);
    }
}

