/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.orderdrafts.task.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.TaskClientCreate1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OrderDraftAddTaskReqV1 {
    private final String taskGroupId;
    private final TaskClientCreate1 task;
    private final Optional<List<String>> cargoIds;
    private final Map<String, Object> additionalProperties;

    private OrderDraftAddTaskReqV1(String taskGroupId, TaskClientCreate1 task, Optional<List<String>> cargoIds, Map<String, Object> additionalProperties) {
        this.taskGroupId = taskGroupId;
        this.task = task;
        this.cargoIds = cargoIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="task_group_id")
    public String getTaskGroupId() {
        return this.taskGroupId;
    }

    @JsonProperty(value="task")
    public TaskClientCreate1 getTask() {
        return this.task;
    }

    @JsonIgnore
    public Optional<List<String>> getCargoIds() {
        if (this.cargoIds == null) {
            return Optional.empty();
        }
        return this.cargoIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cargo_ids")
    private Optional<List<String>> _getCargoIds() {
        return this.cargoIds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OrderDraftAddTaskReqV1 && this.equalTo((OrderDraftAddTaskReqV1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderDraftAddTaskReqV1 other) {
        return this.taskGroupId.equals(other.taskGroupId) && this.task.equals(other.task) && this.cargoIds.equals(other.cargoIds);
    }

    public int hashCode() {
        return Objects.hash(this.taskGroupId, this.task, this.cargoIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TaskGroupIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TaskGroupIdStage,
    TaskStage,
    _FinalStage {
        private String taskGroupId;
        private TaskClientCreate1 task;
        private Optional<List<String>> cargoIds = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(OrderDraftAddTaskReqV1 other) {
            this.taskGroupId(other.getTaskGroupId());
            this.task(other.getTask());
            this.cargoIds(other.getCargoIds());
            return this;
        }

        @Override
        @JsonSetter(value="task_group_id")
        public TaskStage taskGroupId(@NotNull String taskGroupId) {
            this.taskGroupId = Objects.requireNonNull(taskGroupId, "taskGroupId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="task")
        public _FinalStage task(@NotNull TaskClientCreate1 task) {
            this.task = Objects.requireNonNull(task, "task must not be null");
            return this;
        }

        @Override
        public _FinalStage cargoIds(Nullable<List<String>> cargoIds) {
            this.cargoIds = cargoIds.isNull() ? null : (cargoIds.isEmpty() ? Optional.empty() : Optional.of(cargoIds.get()));
            return this;
        }

        @Override
        public _FinalStage cargoIds(List<String> cargoIds) {
            this.cargoIds = Optional.ofNullable(cargoIds);
            return this;
        }

        @Override
        @JsonSetter(value="cargo_ids", nulls=Nulls.SKIP)
        public _FinalStage cargoIds(Optional<List<String>> cargoIds) {
            this.cargoIds = cargoIds;
            return this;
        }

        @Override
        public OrderDraftAddTaskReqV1 build() {
            return new OrderDraftAddTaskReqV1(this.taskGroupId, this.task, this.cargoIds, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public OrderDraftAddTaskReqV1 build();

        public _FinalStage cargoIds(Optional<List<String>> var1);

        public _FinalStage cargoIds(List<String> var1);

        public _FinalStage cargoIds(Nullable<List<String>> var1);
    }

    public static interface TaskStage {
        public _FinalStage task(@NotNull TaskClientCreate1 var1);
    }

    public static interface TaskGroupIdStage {
        public TaskStage taskGroupId(@NotNull String var1);

        public Builder from(OrderDraftAddTaskReqV1 var1);
    }
}

