/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.orders;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.orders.AsyncRawOrdersClient;
import com.chrt.api.resources.orders.expanded.AsyncExpandedClient;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncOrdersClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawOrdersClient rawClient;
    protected final Supplier<AsyncExpandedClient> expandedClient;

    public AsyncOrdersClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawOrdersClient(clientOptions);
        this.expandedClient = Suppliers.memoize(() -> new AsyncExpandedClient(clientOptions));
    }

    public AsyncRawOrdersClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<Boolean> stageV1(String orderId) {
        return this.rawClient.stageV1(orderId).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> stageV1(String orderId, RequestOptions requestOptions) {
        return this.rawClient.stageV1(orderId, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> cancelV1(String orderId) {
        return this.rawClient.cancelV1(orderId).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> cancelV1(String orderId, RequestOptions requestOptions) {
        return this.rawClient.cancelV1(orderId, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public AsyncExpandedClient expanded() {
        return this.expandedClient.get();
    }
}

