/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.orders;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.orders.RawOrdersClient;
import com.chrt.api.resources.orders.expanded.ExpandedClient;
import java.util.function.Supplier;

public class OrdersClient {
    protected final ClientOptions clientOptions;
    private final RawOrdersClient rawClient;
    protected final Supplier<ExpandedClient> expandedClient;

    public OrdersClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawOrdersClient(clientOptions);
        this.expandedClient = Suppliers.memoize(() -> new ExpandedClient(clientOptions));
    }

    public RawOrdersClient withRawResponse() {
        return this.rawClient;
    }

    public boolean stageV1(String orderId) {
        return this.rawClient.stageV1(orderId).body();
    }

    public boolean stageV1(String orderId, RequestOptions requestOptions) {
        return this.rawClient.stageV1(orderId, requestOptions).body();
    }

    public boolean cancelV1(String orderId) {
        return this.rawClient.cancelV1(orderId).body();
    }

    public boolean cancelV1(String orderId, RequestOptions requestOptions) {
        return this.rawClient.cancelV1(orderId, requestOptions).body();
    }

    public ExpandedClient expanded() {
        return this.expandedClient.get();
    }
}

