/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.orders.expanded;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orders.expanded.RawExpandedClient;
import com.chrt.api.resources.orders.expanded.requests.ExpandedListForForwarderOperatorsV1Request;
import com.chrt.api.resources.orders.expanded.requests.ExpandedListForShipperOperatorsV1Request;
import com.chrt.api.types.OrderAndTaskGroupExpandedReq;
import com.chrt.api.types.OrderExpanded;
import com.chrt.api.types.OrdersExpandedListRes;

public class ExpandedClient {
    protected final ClientOptions clientOptions;
    private final RawExpandedClient rawClient;

    public ExpandedClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawExpandedClient(clientOptions);
    }

    public RawExpandedClient withRawResponse() {
        return this.rawClient;
    }

    public OrderExpanded forShipperOperatorsV1(String orderIdOrShortId) {
        return this.rawClient.forShipperOperatorsV1(orderIdOrShortId).body();
    }

    public OrderExpanded forShipperOperatorsV1(String orderIdOrShortId, OrderAndTaskGroupExpandedReq request) {
        return this.rawClient.forShipperOperatorsV1(orderIdOrShortId, request).body();
    }

    public OrderExpanded forShipperOperatorsV1(String orderIdOrShortId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        return this.rawClient.forShipperOperatorsV1(orderIdOrShortId, request, requestOptions).body();
    }

    public OrderExpanded forForwarderOperatorsV1(String orderIdOrShortId) {
        return this.rawClient.forForwarderOperatorsV1(orderIdOrShortId).body();
    }

    public OrderExpanded forForwarderOperatorsV1(String orderIdOrShortId, OrderAndTaskGroupExpandedReq request) {
        return this.rawClient.forForwarderOperatorsV1(orderIdOrShortId, request).body();
    }

    public OrderExpanded forForwarderOperatorsV1(String orderIdOrShortId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        return this.rawClient.forForwarderOperatorsV1(orderIdOrShortId, request, requestOptions).body();
    }

    public OrdersExpandedListRes listForForwarderOperatorsV1(ExpandedListForForwarderOperatorsV1Request request) {
        return this.rawClient.listForForwarderOperatorsV1(request).body();
    }

    public OrdersExpandedListRes listForForwarderOperatorsV1(ExpandedListForForwarderOperatorsV1Request request, RequestOptions requestOptions) {
        return this.rawClient.listForForwarderOperatorsV1(request, requestOptions).body();
    }

    public OrdersExpandedListRes listForShipperOperatorsV1(ExpandedListForShipperOperatorsV1Request request) {
        return this.rawClient.listForShipperOperatorsV1(request).body();
    }

    public OrdersExpandedListRes listForShipperOperatorsV1(ExpandedListForShipperOperatorsV1Request request, RequestOptions requestOptions) {
        return this.rawClient.listForShipperOperatorsV1(request, requestOptions).body();
    }
}

