/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.orders.expanded;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.MediaTypes;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.QueryStringMapper;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.resources.orders.expanded.requests.ExpandedListForForwarderOperatorsV1Request;
import com.chrt.api.resources.orders.expanded.requests.ExpandedListForShipperOperatorsV1Request;
import com.chrt.api.types.HttpValidationError;
import com.chrt.api.types.OrderAndTaskGroupExpandedReq;
import com.chrt.api.types.OrderExpanded;
import com.chrt.api.types.OrdersExpandedListRes;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawExpandedClient {
    protected final ClientOptions clientOptions;

    public RawExpandedClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public ChrtApiHttpResponse<OrderExpanded> forShipperOperatorsV1(String orderIdOrShortId) {
        return this.forShipperOperatorsV1(orderIdOrShortId, OrderAndTaskGroupExpandedReq.builder().build());
    }

    public ChrtApiHttpResponse<OrderExpanded> forShipperOperatorsV1(String orderIdOrShortId, OrderAndTaskGroupExpandedReq request) {
        return this.forShipperOperatorsV1(orderIdOrShortId, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<OrderExpanded> forShipperOperatorsV1(String orderIdOrShortId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/orders/expanded/for_shipper_operators/v1").addPathSegment(orderIdOrShortId).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<OrderExpanded> chrtApiHttpResponse = new ChrtApiHttpResponse<OrderExpanded>((OrderExpanded)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, OrderExpanded.class), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<OrderExpanded> forForwarderOperatorsV1(String orderIdOrShortId) {
        return this.forForwarderOperatorsV1(orderIdOrShortId, OrderAndTaskGroupExpandedReq.builder().build());
    }

    public ChrtApiHttpResponse<OrderExpanded> forForwarderOperatorsV1(String orderIdOrShortId, OrderAndTaskGroupExpandedReq request) {
        return this.forForwarderOperatorsV1(orderIdOrShortId, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<OrderExpanded> forForwarderOperatorsV1(String orderIdOrShortId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/orders/expanded/for_forwarder_operators/v1").addPathSegment(orderIdOrShortId).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<OrderExpanded> chrtApiHttpResponse = new ChrtApiHttpResponse<OrderExpanded>((OrderExpanded)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, OrderExpanded.class), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<OrdersExpandedListRes> listForForwarderOperatorsV1(ExpandedListForForwarderOperatorsV1Request request) {
        return this.listForForwarderOperatorsV1(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<OrdersExpandedListRes> listForForwarderOperatorsV1(ExpandedListForForwarderOperatorsV1Request request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/orders/expanded/list/for_forwarder_operators/v1");
        if (request.getSortBy().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "sort_by", request.getSortBy().get(), false);
        }
        if (request.getSortOrder().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "sort_order", request.getSortOrder().get(), false);
        }
        if (request.getPage().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "page", request.getPage().get(), false);
        }
        if (request.getPageSize().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "page_size", request.getPageSize().get(), false);
        }
        if (request.getFilterDraftStartedAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_draft_started_at_timestamp_lte", request.getFilterDraftStartedAtTimestampLte().get(), false);
        }
        if (request.getFilterDraftStartedAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_draft_started_at_timestamp_gte", request.getFilterDraftStartedAtTimestampGte().get(), false);
        }
        if (request.getFilterStagedAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_staged_at_timestamp_lte", request.getFilterStagedAtTimestampLte().get(), false);
        }
        if (request.getFilterStagedAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_staged_at_timestamp_gte", request.getFilterStagedAtTimestampGte().get(), false);
        }
        if (request.getFilterInProgressAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_in_progress_at_timestamp_lte", request.getFilterInProgressAtTimestampLte().get(), false);
        }
        if (request.getFilterInProgressAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_in_progress_at_timestamp_gte", request.getFilterInProgressAtTimestampGte().get(), false);
        }
        if (request.getFilterCompletedAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_completed_at_timestamp_lte", request.getFilterCompletedAtTimestampLte().get(), false);
        }
        if (request.getFilterCompletedAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_completed_at_timestamp_gte", request.getFilterCompletedAtTimestampGte().get(), false);
        }
        if (request.getFilterExceptionAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_exception_at_timestamp_lte", request.getFilterExceptionAtTimestampLte().get(), false);
        }
        if (request.getFilterExceptionAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_exception_at_timestamp_gte", request.getFilterExceptionAtTimestampGte().get(), false);
        }
        if (request.getFilterOrderCancelledAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_order_cancelled_at_timestamp_lte", request.getFilterOrderCancelledAtTimestampLte().get(), false);
        }
        if (request.getFilterOrderCancelledAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_order_cancelled_at_timestamp_gte", request.getFilterOrderCancelledAtTimestampGte().get(), false);
        }
        if (request.getFilterStatus().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_status", request.getFilterStatus().get(), true);
        }
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request.getBody()), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<OrdersExpandedListRes> chrtApiHttpResponse = new ChrtApiHttpResponse<OrdersExpandedListRes>((OrdersExpandedListRes)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, OrdersExpandedListRes.class), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<OrdersExpandedListRes> listForShipperOperatorsV1(ExpandedListForShipperOperatorsV1Request request) {
        return this.listForShipperOperatorsV1(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<OrdersExpandedListRes> listForShipperOperatorsV1(ExpandedListForShipperOperatorsV1Request request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/orders/expanded/list/for_shipper_operators/v1");
        if (request.getSortBy().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "sort_by", request.getSortBy().get(), false);
        }
        if (request.getSortOrder().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "sort_order", request.getSortOrder().get(), false);
        }
        if (request.getPage().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "page", request.getPage().get(), false);
        }
        if (request.getPageSize().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "page_size", request.getPageSize().get(), false);
        }
        if (request.getFilterDraftStartedAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_draft_started_at_timestamp_lte", request.getFilterDraftStartedAtTimestampLte().get(), false);
        }
        if (request.getFilterDraftStartedAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_draft_started_at_timestamp_gte", request.getFilterDraftStartedAtTimestampGte().get(), false);
        }
        if (request.getFilterStagedAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_staged_at_timestamp_lte", request.getFilterStagedAtTimestampLte().get(), false);
        }
        if (request.getFilterStagedAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_staged_at_timestamp_gte", request.getFilterStagedAtTimestampGte().get(), false);
        }
        if (request.getFilterInProgressAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_in_progress_at_timestamp_lte", request.getFilterInProgressAtTimestampLte().get(), false);
        }
        if (request.getFilterInProgressAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_in_progress_at_timestamp_gte", request.getFilterInProgressAtTimestampGte().get(), false);
        }
        if (request.getFilterCompletedAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_completed_at_timestamp_lte", request.getFilterCompletedAtTimestampLte().get(), false);
        }
        if (request.getFilterCompletedAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_completed_at_timestamp_gte", request.getFilterCompletedAtTimestampGte().get(), false);
        }
        if (request.getFilterExceptionAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_exception_at_timestamp_lte", request.getFilterExceptionAtTimestampLte().get(), false);
        }
        if (request.getFilterExceptionAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_exception_at_timestamp_gte", request.getFilterExceptionAtTimestampGte().get(), false);
        }
        if (request.getFilterOrderCancelledAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_order_cancelled_at_timestamp_lte", request.getFilterOrderCancelledAtTimestampLte().get(), false);
        }
        if (request.getFilterOrderCancelledAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_order_cancelled_at_timestamp_gte", request.getFilterOrderCancelledAtTimestampGte().get(), false);
        }
        if (request.getFilterStatus().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_status", request.getFilterStatus().get(), true);
        }
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request.getBody()), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<OrdersExpandedListRes> chrtApiHttpResponse = new ChrtApiHttpResponse<OrdersExpandedListRes>((OrdersExpandedListRes)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, OrdersExpandedListRes.class), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }
}

