/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.orginfoforconnections;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.orginfoforconnections.courier.CourierClient;
import com.chrt.api.resources.orginfoforconnections.forwarder.ForwarderClient;
import com.chrt.api.resources.orginfoforconnections.shipper.ShipperClient;
import java.util.function.Supplier;

public class OrgInfoForConnectionsClient {
    protected final ClientOptions clientOptions;
    protected final Supplier<ShipperClient> shipperClient;
    protected final Supplier<CourierClient> courierClient;
    protected final Supplier<ForwarderClient> forwarderClient;

    public OrgInfoForConnectionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.shipperClient = Suppliers.memoize(() -> new ShipperClient(clientOptions));
        this.courierClient = Suppliers.memoize(() -> new CourierClient(clientOptions));
        this.forwarderClient = Suppliers.memoize(() -> new ForwarderClient(clientOptions));
    }

    public ShipperClient shipper() {
        return this.shipperClient.get();
    }

    public CourierClient courier() {
        return this.courierClient.get();
    }

    public ForwarderClient forwarder() {
        return this.forwarderClient.get();
    }
}

