/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.orginfoforconnections.shipper;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orginfoforconnections.shipper.AsyncRawShipperClient;
import com.chrt.api.resources.orginfoforconnections.shipper.requests.ShipperOrgInfoForConnectionsClientCreate1;
import com.chrt.api.resources.orginfoforconnections.shipper.requests.ShipperOrgInfoForConnectionsClientUpdate1;
import com.chrt.api.types.ShipperOrgInfoForConnections1;
import java.util.concurrent.CompletableFuture;

public class AsyncShipperClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawShipperClient rawClient;

    public AsyncShipperClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawShipperClient(clientOptions);
    }

    public AsyncRawShipperClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<ShipperOrgInfoForConnections1> getV1() {
        return this.rawClient.getV1().thenApply(response -> (ShipperOrgInfoForConnections1)response.body());
    }

    public CompletableFuture<ShipperOrgInfoForConnections1> getV1(RequestOptions requestOptions) {
        return this.rawClient.getV1(requestOptions).thenApply(response -> (ShipperOrgInfoForConnections1)response.body());
    }

    public CompletableFuture<String> createV1(ShipperOrgInfoForConnectionsClientCreate1 request) {
        return this.rawClient.createV1(request).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> createV1(ShipperOrgInfoForConnectionsClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<Boolean> updateV1() {
        return this.rawClient.updateV1().thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateV1(ShipperOrgInfoForConnectionsClientUpdate1 request) {
        return this.rawClient.updateV1(request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateV1(ShipperOrgInfoForConnectionsClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(request, requestOptions).thenApply(response -> (Boolean)response.body());
    }
}

