/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.orgprofiles;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orgprofiles.AsyncRawOrgProfilesClient;
import com.chrt.api.resources.orgprofiles.requests.CourierOrgProfileClientCreate1;
import com.chrt.api.resources.orgprofiles.requests.CourierOrgProfileClientUpdate1;
import com.chrt.api.resources.orgprofiles.requests.ForwarderOrgProfileClientCreate1;
import com.chrt.api.resources.orgprofiles.requests.ForwarderOrgProfileClientUpdate1;
import com.chrt.api.types.OrgProfileRes1;
import java.util.concurrent.CompletableFuture;

public class AsyncOrgProfilesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawOrgProfilesClient rawClient;

    public AsyncOrgProfilesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawOrgProfilesClient(clientOptions);
    }

    public AsyncRawOrgProfilesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<OrgProfileRes1> getV1() {
        return this.rawClient.getV1().thenApply(response -> (OrgProfileRes1)response.body());
    }

    public CompletableFuture<OrgProfileRes1> getV1(RequestOptions requestOptions) {
        return this.rawClient.getV1(requestOptions).thenApply(response -> (OrgProfileRes1)response.body());
    }

    public CompletableFuture<String> createCourierV1(CourierOrgProfileClientCreate1 request) {
        return this.rawClient.createCourierV1(request).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> createCourierV1(CourierOrgProfileClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createCourierV1(request, requestOptions).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> createForwarderV1(ForwarderOrgProfileClientCreate1 request) {
        return this.rawClient.createForwarderV1(request).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> createForwarderV1(ForwarderOrgProfileClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createForwarderV1(request, requestOptions).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<Boolean> updateCourierV1() {
        return this.rawClient.updateCourierV1().thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateCourierV1(CourierOrgProfileClientUpdate1 request) {
        return this.rawClient.updateCourierV1(request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateCourierV1(CourierOrgProfileClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateCourierV1(request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateForwarderV1() {
        return this.rawClient.updateForwarderV1().thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateForwarderV1(ForwarderOrgProfileClientUpdate1 request) {
        return this.rawClient.updateForwarderV1(request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateForwarderV1(ForwarderOrgProfileClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateForwarderV1(request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<OrgProfileRes1> getByHandleV1(String handle) {
        return this.rawClient.getByHandleV1(handle).thenApply(response -> (OrgProfileRes1)response.body());
    }

    public CompletableFuture<OrgProfileRes1> getByHandleV1(String handle, RequestOptions requestOptions) {
        return this.rawClient.getByHandleV1(handle, requestOptions).thenApply(response -> (OrgProfileRes1)response.body());
    }

    public CompletableFuture<String> getAvatarV1(String handle) {
        return this.rawClient.getAvatarV1(handle).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> getAvatarV1(String handle, RequestOptions requestOptions) {
        return this.rawClient.getAvatarV1(handle, requestOptions).thenApply(response -> (String)response.body());
    }
}

