/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.orgs;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orgs.AsyncRawOrgsClient;
import com.chrt.api.resources.orgs.requests.CreateOrgPublicDataReq;
import com.chrt.api.resources.orgs.requests.SetOrgTypeReq;
import com.chrt.api.resources.orgs.requests.UpdateOrgPublicDataReq;
import com.chrt.api.types.CreateOrgPublicDataRes;
import com.chrt.api.types.OrgMemberDetails;
import com.chrt.api.types.OrgPublicData1;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class AsyncOrgsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawOrgsClient rawClient;

    public AsyncOrgsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawOrgsClient(clientOptions);
    }

    public AsyncRawOrgsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<Map<String, Object>> getInfoV1() {
        return this.rawClient.getInfoV1().thenApply(response -> (Map)response.body());
    }

    public CompletableFuture<Map<String, Object>> getInfoV1(RequestOptions requestOptions) {
        return this.rawClient.getInfoV1(requestOptions).thenApply(response -> (Map)response.body());
    }

    public CompletableFuture<List<OrgMemberDetails>> listMembersV1() {
        return this.rawClient.listMembersV1().thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<OrgMemberDetails>> listMembersV1(RequestOptions requestOptions) {
        return this.rawClient.listMembersV1(requestOptions).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<OrgPublicData1> getOrgPublicDataV1() {
        return this.rawClient.getOrgPublicDataV1().thenApply(response -> (OrgPublicData1)response.body());
    }

    public CompletableFuture<OrgPublicData1> getOrgPublicDataV1(RequestOptions requestOptions) {
        return this.rawClient.getOrgPublicDataV1(requestOptions).thenApply(response -> (OrgPublicData1)response.body());
    }

    public CompletableFuture<CreateOrgPublicDataRes> createOrgPublicDataV1() {
        return this.rawClient.createOrgPublicDataV1().thenApply(response -> (CreateOrgPublicDataRes)response.body());
    }

    public CompletableFuture<CreateOrgPublicDataRes> createOrgPublicDataV1(CreateOrgPublicDataReq request) {
        return this.rawClient.createOrgPublicDataV1(request).thenApply(response -> (CreateOrgPublicDataRes)response.body());
    }

    public CompletableFuture<CreateOrgPublicDataRes> createOrgPublicDataV1(CreateOrgPublicDataReq request, RequestOptions requestOptions) {
        return this.rawClient.createOrgPublicDataV1(request, requestOptions).thenApply(response -> (CreateOrgPublicDataRes)response.body());
    }

    public CompletableFuture<Boolean> updateOrgPublicDataV1() {
        return this.rawClient.updateOrgPublicDataV1().thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateOrgPublicDataV1(UpdateOrgPublicDataReq request) {
        return this.rawClient.updateOrgPublicDataV1(request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateOrgPublicDataV1(UpdateOrgPublicDataReq request, RequestOptions requestOptions) {
        return this.rawClient.updateOrgPublicDataV1(request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<OrgPublicData1> getOrgPublicDataByOrgIdV1(String orgId) {
        return this.rawClient.getOrgPublicDataByOrgIdV1(orgId).thenApply(response -> (OrgPublicData1)response.body());
    }

    public CompletableFuture<OrgPublicData1> getOrgPublicDataByOrgIdV1(String orgId, RequestOptions requestOptions) {
        return this.rawClient.getOrgPublicDataByOrgIdV1(orgId, requestOptions).thenApply(response -> (OrgPublicData1)response.body());
    }

    public CompletableFuture<Boolean> getOrgPublicDataHandleAvailabilityV1(String handle) {
        return this.rawClient.getOrgPublicDataHandleAvailabilityV1(handle).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> getOrgPublicDataHandleAvailabilityV1(String handle, RequestOptions requestOptions) {
        return this.rawClient.getOrgPublicDataHandleAvailabilityV1(handle, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> setOrgTypeV1(SetOrgTypeReq request) {
        return this.rawClient.setOrgTypeV1(request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> setOrgTypeV1(SetOrgTypeReq request, RequestOptions requestOptions) {
        return this.rawClient.setOrgTypeV1(request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<String> getStripeConnectAccountIdV1() {
        return this.rawClient.getStripeConnectAccountIdV1().thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> getStripeConnectAccountIdV1(RequestOptions requestOptions) {
        return this.rawClient.getStripeConnectAccountIdV1(requestOptions).thenApply(response -> (String)response.body());
    }
}

