/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.orgs.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateOrgPublicDataReq {
    private final Optional<String> handle;
    private final Optional<String> companyName;
    private final Map<String, Object> additionalProperties;

    private CreateOrgPublicDataReq(Optional<String> handle, Optional<String> companyName, Map<String, Object> additionalProperties) {
        this.handle = handle;
        this.companyName = companyName;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getHandle() {
        if (this.handle == null) {
            return Optional.empty();
        }
        return this.handle;
    }

    @JsonIgnore
    public Optional<String> getCompanyName() {
        if (this.companyName == null) {
            return Optional.empty();
        }
        return this.companyName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="handle")
    private Optional<String> _getHandle() {
        return this.handle;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="company_name")
    private Optional<String> _getCompanyName() {
        return this.companyName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateOrgPublicDataReq && this.equalTo((CreateOrgPublicDataReq)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateOrgPublicDataReq other) {
        return this.handle.equals(other.handle) && this.companyName.equals(other.companyName);
    }

    public int hashCode() {
        return Objects.hash(this.handle, this.companyName);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> handle = Optional.empty();
        private Optional<String> companyName = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreateOrgPublicDataReq other) {
            this.handle(other.getHandle());
            this.companyName(other.getCompanyName());
            return this;
        }

        @JsonSetter(value="handle", nulls=Nulls.SKIP)
        public Builder handle(Optional<String> handle) {
            this.handle = handle;
            return this;
        }

        public Builder handle(String handle) {
            this.handle = Optional.ofNullable(handle);
            return this;
        }

        public Builder handle(Nullable<String> handle) {
            this.handle = handle.isNull() ? null : (handle.isEmpty() ? Optional.empty() : Optional.of(handle.get()));
            return this;
        }

        @JsonSetter(value="company_name", nulls=Nulls.SKIP)
        public Builder companyName(Optional<String> companyName) {
            this.companyName = companyName;
            return this;
        }

        public Builder companyName(String companyName) {
            this.companyName = Optional.ofNullable(companyName);
            return this;
        }

        public Builder companyName(Nullable<String> companyName) {
            this.companyName = companyName.isNull() ? null : (companyName.isEmpty() ? Optional.empty() : Optional.of(companyName.get()));
            return this;
        }

        public CreateOrgPublicDataReq build() {
            return new CreateOrgPublicDataReq(this.handle, this.companyName, this.additionalProperties);
        }
    }
}

