/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.payments;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.payments.AsyncRawPaymentsClient;
import com.chrt.api.resources.payments.requests.CreateCheckoutSessionReq;
import com.chrt.api.resources.payments.requests.GenerateInvoiceReq;
import com.chrt.api.types.CreateCheckoutSessionRes;
import com.chrt.api.types.CreateConnectAccountLinkRes;
import com.chrt.api.types.CreateConnectAccountRes;
import com.chrt.api.types.GenerateInvoiceRes;
import java.util.concurrent.CompletableFuture;

public class AsyncPaymentsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawPaymentsClient rawClient;

    public AsyncPaymentsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawPaymentsClient(clientOptions);
    }

    public AsyncRawPaymentsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<GenerateInvoiceRes> generateInvoiceV1(GenerateInvoiceReq request) {
        return this.rawClient.generateInvoiceV1(request).thenApply(response -> (GenerateInvoiceRes)response.body());
    }

    public CompletableFuture<GenerateInvoiceRes> generateInvoiceV1(GenerateInvoiceReq request, RequestOptions requestOptions) {
        return this.rawClient.generateInvoiceV1(request, requestOptions).thenApply(response -> (GenerateInvoiceRes)response.body());
    }

    public CompletableFuture<CreateCheckoutSessionRes> createCheckoutSessionV1(CreateCheckoutSessionReq request) {
        return this.rawClient.createCheckoutSessionV1(request).thenApply(response -> (CreateCheckoutSessionRes)response.body());
    }

    public CompletableFuture<CreateCheckoutSessionRes> createCheckoutSessionV1(CreateCheckoutSessionReq request, RequestOptions requestOptions) {
        return this.rawClient.createCheckoutSessionV1(request, requestOptions).thenApply(response -> (CreateCheckoutSessionRes)response.body());
    }

    public CompletableFuture<Boolean> syncStripeToClerkV1() {
        return this.rawClient.syncStripeToClerkV1().thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> syncStripeToClerkV1(RequestOptions requestOptions) {
        return this.rawClient.syncStripeToClerkV1(requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<CreateConnectAccountRes> createConnectAccountV1() {
        return this.rawClient.createConnectAccountV1().thenApply(response -> (CreateConnectAccountRes)response.body());
    }

    public CompletableFuture<CreateConnectAccountRes> createConnectAccountV1(RequestOptions requestOptions) {
        return this.rawClient.createConnectAccountV1(requestOptions).thenApply(response -> (CreateConnectAccountRes)response.body());
    }

    public CompletableFuture<CreateConnectAccountLinkRes> createConnectAccountLinkV1() {
        return this.rawClient.createConnectAccountLinkV1().thenApply(response -> (CreateConnectAccountLinkRes)response.body());
    }

    public CompletableFuture<CreateConnectAccountLinkRes> createConnectAccountLinkV1(RequestOptions requestOptions) {
        return this.rawClient.createConnectAccountLinkV1(requestOptions).thenApply(response -> (CreateConnectAccountLinkRes)response.body());
    }
}

