/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.payments;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.payments.RawPaymentsClient;
import com.chrt.api.resources.payments.requests.CreateCheckoutSessionReq;
import com.chrt.api.resources.payments.requests.GenerateInvoiceReq;
import com.chrt.api.types.CreateCheckoutSessionRes;
import com.chrt.api.types.CreateConnectAccountLinkRes;
import com.chrt.api.types.CreateConnectAccountRes;
import com.chrt.api.types.GenerateInvoiceRes;

public class PaymentsClient {
    protected final ClientOptions clientOptions;
    private final RawPaymentsClient rawClient;

    public PaymentsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawPaymentsClient(clientOptions);
    }

    public RawPaymentsClient withRawResponse() {
        return this.rawClient;
    }

    public GenerateInvoiceRes generateInvoiceV1(GenerateInvoiceReq request) {
        return this.rawClient.generateInvoiceV1(request).body();
    }

    public GenerateInvoiceRes generateInvoiceV1(GenerateInvoiceReq request, RequestOptions requestOptions) {
        return this.rawClient.generateInvoiceV1(request, requestOptions).body();
    }

    public CreateCheckoutSessionRes createCheckoutSessionV1(CreateCheckoutSessionReq request) {
        return this.rawClient.createCheckoutSessionV1(request).body();
    }

    public CreateCheckoutSessionRes createCheckoutSessionV1(CreateCheckoutSessionReq request, RequestOptions requestOptions) {
        return this.rawClient.createCheckoutSessionV1(request, requestOptions).body();
    }

    public boolean syncStripeToClerkV1() {
        return this.rawClient.syncStripeToClerkV1().body();
    }

    public boolean syncStripeToClerkV1(RequestOptions requestOptions) {
        return this.rawClient.syncStripeToClerkV1(requestOptions).body();
    }

    public CreateConnectAccountRes createConnectAccountV1() {
        return this.rawClient.createConnectAccountV1().body();
    }

    public CreateConnectAccountRes createConnectAccountV1(RequestOptions requestOptions) {
        return this.rawClient.createConnectAccountV1(requestOptions).body();
    }

    public CreateConnectAccountLinkRes createConnectAccountLinkV1() {
        return this.rawClient.createConnectAccountLinkV1().body();
    }

    public CreateConnectAccountLinkRes createConnectAccountLinkV1(RequestOptions requestOptions) {
        return this.rawClient.createConnectAccountLinkV1(requestOptions).body();
    }
}

