/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.payments;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.MediaTypes;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.resources.payments.requests.CreateCheckoutSessionReq;
import com.chrt.api.resources.payments.requests.GenerateInvoiceReq;
import com.chrt.api.types.CreateCheckoutSessionRes;
import com.chrt.api.types.CreateConnectAccountLinkRes;
import com.chrt.api.types.CreateConnectAccountRes;
import com.chrt.api.types.GenerateInvoiceRes;
import com.chrt.api.types.HttpValidationError;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawPaymentsClient {
    protected final ClientOptions clientOptions;

    public RawPaymentsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public ChrtApiHttpResponse<GenerateInvoiceRes> generateInvoiceV1(GenerateInvoiceReq request) {
        return this.generateInvoiceV1(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<GenerateInvoiceRes> generateInvoiceV1(GenerateInvoiceReq request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("generate-invoice/v1").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<GenerateInvoiceRes> chrtApiHttpResponse = new ChrtApiHttpResponse<GenerateInvoiceRes>((GenerateInvoiceRes)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GenerateInvoiceRes.class), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<CreateCheckoutSessionRes> createCheckoutSessionV1(CreateCheckoutSessionReq request) {
        return this.createCheckoutSessionV1(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<CreateCheckoutSessionRes> createCheckoutSessionV1(CreateCheckoutSessionReq request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("create-checkout-session/v1").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<CreateCheckoutSessionRes> chrtApiHttpResponse = new ChrtApiHttpResponse<CreateCheckoutSessionRes>((CreateCheckoutSessionRes)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, CreateCheckoutSessionRes.class), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<Boolean> syncStripeToClerkV1() {
        return this.syncStripeToClerkV1(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<Boolean> syncStripeToClerkV1(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("sync_stripe_to_clerk/v1").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (!response.isSuccessful()) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            ChrtApiHttpResponse<Boolean> chrtApiHttpResponse = new ChrtApiHttpResponse<Boolean>((Boolean)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Boolean.TYPE), response);
            return chrtApiHttpResponse;
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<CreateConnectAccountRes> createConnectAccountV1() {
        return this.createConnectAccountV1(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<CreateConnectAccountRes> createConnectAccountV1(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("create-connect-account/v1").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", RequestBody.create((String)"", null)).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (!response.isSuccessful()) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            ChrtApiHttpResponse<CreateConnectAccountRes> chrtApiHttpResponse = new ChrtApiHttpResponse<CreateConnectAccountRes>((CreateConnectAccountRes)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, CreateConnectAccountRes.class), response);
            return chrtApiHttpResponse;
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<CreateConnectAccountLinkRes> createConnectAccountLinkV1() {
        return this.createConnectAccountLinkV1(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<CreateConnectAccountLinkRes> createConnectAccountLinkV1(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("create-connect-account-link/v1").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", RequestBody.create((String)"", null)).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (!response.isSuccessful()) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            ChrtApiHttpResponse<CreateConnectAccountLinkRes> chrtApiHttpResponse = new ChrtApiHttpResponse<CreateConnectAccountLinkRes>((CreateConnectAccountLinkRes)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, CreateConnectAccountLinkRes.class), response);
            return chrtApiHttpResponse;
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }
}

