/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.payments.requests;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GenerateInvoiceReq {
    private final String shipperPayCourierStatementId;
    private final Optional<Integer> daysUntilDue;
    private final Optional<String> description;
    private final Map<String, Object> additionalProperties;

    private GenerateInvoiceReq(String shipperPayCourierStatementId, Optional<Integer> daysUntilDue, Optional<String> description, Map<String, Object> additionalProperties) {
        this.shipperPayCourierStatementId = shipperPayCourierStatementId;
        this.daysUntilDue = daysUntilDue;
        this.description = description;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="shipper_pay_courier_statement_id")
    public String getShipperPayCourierStatementId() {
        return this.shipperPayCourierStatementId;
    }

    @JsonProperty(value="days_until_due")
    public Optional<Integer> getDaysUntilDue() {
        return this.daysUntilDue;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GenerateInvoiceReq && this.equalTo((GenerateInvoiceReq)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GenerateInvoiceReq other) {
        return this.shipperPayCourierStatementId.equals(other.shipperPayCourierStatementId) && this.daysUntilDue.equals(other.daysUntilDue) && this.description.equals(other.description);
    }

    public int hashCode() {
        return Objects.hash(this.shipperPayCourierStatementId, this.daysUntilDue, this.description);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ShipperPayCourierStatementIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ShipperPayCourierStatementIdStage,
    _FinalStage {
        private String shipperPayCourierStatementId;
        private Optional<String> description = Optional.empty();
        private Optional<Integer> daysUntilDue = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GenerateInvoiceReq other) {
            this.shipperPayCourierStatementId(other.getShipperPayCourierStatementId());
            this.daysUntilDue(other.getDaysUntilDue());
            this.description(other.getDescription());
            return this;
        }

        @Override
        @JsonSetter(value="shipper_pay_courier_statement_id")
        public _FinalStage shipperPayCourierStatementId(@NotNull String shipperPayCourierStatementId) {
            this.shipperPayCourierStatementId = Objects.requireNonNull(shipperPayCourierStatementId, "shipperPayCourierStatementId must not be null");
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public _FinalStage daysUntilDue(Integer daysUntilDue) {
            this.daysUntilDue = Optional.ofNullable(daysUntilDue);
            return this;
        }

        @Override
        @JsonSetter(value="days_until_due", nulls=Nulls.SKIP)
        public _FinalStage daysUntilDue(Optional<Integer> daysUntilDue) {
            this.daysUntilDue = daysUntilDue;
            return this;
        }

        @Override
        public GenerateInvoiceReq build() {
            return new GenerateInvoiceReq(this.shipperPayCourierStatementId, this.daysUntilDue, this.description, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GenerateInvoiceReq build();

        public _FinalStage daysUntilDue(Optional<Integer> var1);

        public _FinalStage daysUntilDue(Integer var1);

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);
    }

    public static interface ShipperPayCourierStatementIdStage {
        public _FinalStage shipperPayCourierStatementId(@NotNull String var1);

        public Builder from(GenerateInvoiceReq var1);
    }
}

