/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.shippercontactinfo;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.shippercontactinfo.AsyncRawShipperContactInfoClient;
import com.chrt.api.resources.shippercontactinfo.requests.ShipperContactClientUpdate1;
import com.chrt.api.types.ShipperContact1;
import com.chrt.api.types.ShipperContactClientCreate1;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncShipperContactInfoClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawShipperContactInfoClient rawClient;

    public AsyncShipperContactInfoClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawShipperContactInfoClient(clientOptions);
    }

    public AsyncRawShipperContactInfoClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<ShipperContact1> getCallerV1() {
        return this.rawClient.getCallerV1().thenApply(response -> (ShipperContact1)response.body());
    }

    public CompletableFuture<ShipperContact1> getCallerV1(RequestOptions requestOptions) {
        return this.rawClient.getCallerV1(requestOptions).thenApply(response -> (ShipperContact1)response.body());
    }

    public CompletableFuture<List<ShipperContact1>> listV1() {
        return this.rawClient.listV1().thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<ShipperContact1>> listV1(RequestOptions requestOptions) {
        return this.rawClient.listV1(requestOptions).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<ShipperContact1>> listCourierContactsV1(String shipperOrgId) {
        return this.rawClient.listCourierContactsV1(shipperOrgId).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<ShipperContact1>> listCourierContactsV1(String shipperOrgId, RequestOptions requestOptions) {
        return this.rawClient.listCourierContactsV1(shipperOrgId, requestOptions).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<ShipperContact1>> listForwarderContactsV1(String shipperOrgId) {
        return this.rawClient.listForwarderContactsV1(shipperOrgId).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<ShipperContact1>> listForwarderContactsV1(String shipperOrgId, RequestOptions requestOptions) {
        return this.rawClient.listForwarderContactsV1(shipperOrgId, requestOptions).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<ShipperContact1>> listOffPlatformContactsV1(String offChrtShipperOrgId) {
        return this.rawClient.listOffPlatformContactsV1(offChrtShipperOrgId).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<ShipperContact1>> listOffPlatformContactsV1(String offChrtShipperOrgId, RequestOptions requestOptions) {
        return this.rawClient.listOffPlatformContactsV1(offChrtShipperOrgId, requestOptions).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<ShipperContact1> getV1(String id) {
        return this.rawClient.getV1(id).thenApply(response -> (ShipperContact1)response.body());
    }

    public CompletableFuture<ShipperContact1> getV1(String id, RequestOptions requestOptions) {
        return this.rawClient.getV1(id, requestOptions).thenApply(response -> (ShipperContact1)response.body());
    }

    public CompletableFuture<String> createOnPlatformV1(ShipperContactClientCreate1 request) {
        return this.rawClient.createOnPlatformV1(request).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> createOnPlatformV1(ShipperContactClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createOnPlatformV1(request, requestOptions).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> createOffPlatformV1(ShipperContactClientCreate1 request) {
        return this.rawClient.createOffPlatformV1(request).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> createOffPlatformV1(ShipperContactClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createOffPlatformV1(request, requestOptions).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<Boolean> updateV1(String shipperContactInfoId) {
        return this.rawClient.updateV1(shipperContactInfoId).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateV1(String shipperContactInfoId, ShipperContactClientUpdate1 request) {
        return this.rawClient.updateV1(shipperContactInfoId, request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateV1(String shipperContactInfoId, ShipperContactClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(shipperContactInfoId, request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> deleteV1(String id) {
        return this.rawClient.deleteV1(id).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> deleteV1(String id, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(id, requestOptions).thenApply(response -> (Boolean)response.body());
    }
}

