/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.shipperpaycourierlineitemgroups;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.shipperpaycourierlineitemgroups.AsyncRawShipperPayCourierLineItemGroupsClient;
import com.chrt.api.resources.shipperpaycourierlineitemgroups.addlineitems.AsyncAddLineItemsClient;
import com.chrt.api.resources.shipperpaycourierlineitemgroups.courier.AsyncCourierClient;
import com.chrt.api.resources.shipperpaycourierlineitemgroups.removelineitems.AsyncRemoveLineItemsClient;
import com.chrt.api.resources.shipperpaycourierlineitemgroups.shipper.AsyncShipperClient;
import com.chrt.api.types.ShipperPayCourierLineItemGroup1;
import com.chrt.api.types.ShipperPayCourierLineItemGroupCreateReq;
import com.chrt.api.types.ShipperPayCourierLineItemGroupServerCreate1;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncShipperPayCourierLineItemGroupsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawShipperPayCourierLineItemGroupsClient rawClient;
    protected final Supplier<AsyncShipperClient> shipperClient;
    protected final Supplier<AsyncCourierClient> courierClient;
    protected final Supplier<AsyncAddLineItemsClient> addLineItemsClient;
    protected final Supplier<AsyncRemoveLineItemsClient> removeLineItemsClient;

    public AsyncShipperPayCourierLineItemGroupsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawShipperPayCourierLineItemGroupsClient(clientOptions);
        this.shipperClient = Suppliers.memoize(() -> new AsyncShipperClient(clientOptions));
        this.courierClient = Suppliers.memoize(() -> new AsyncCourierClient(clientOptions));
        this.addLineItemsClient = Suppliers.memoize(() -> new AsyncAddLineItemsClient(clientOptions));
        this.removeLineItemsClient = Suppliers.memoize(() -> new AsyncRemoveLineItemsClient(clientOptions));
    }

    public AsyncRawShipperPayCourierLineItemGroupsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<ShipperPayCourierLineItemGroup1> getByIdV1(String id) {
        return this.rawClient.getByIdV1(id).thenApply(response -> (ShipperPayCourierLineItemGroup1)response.body());
    }

    public CompletableFuture<ShipperPayCourierLineItemGroup1> getByIdV1(String id, RequestOptions requestOptions) {
        return this.rawClient.getByIdV1(id, requestOptions).thenApply(response -> (ShipperPayCourierLineItemGroup1)response.body());
    }

    public CompletableFuture<Boolean> deleteByIdV1(String id) {
        return this.rawClient.deleteByIdV1(id).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> deleteByIdV1(String id, RequestOptions requestOptions) {
        return this.rawClient.deleteByIdV1(id, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<ShipperPayCourierLineItemGroup1> byTaskGroupIdV1(String taskGroupId) {
        return this.rawClient.byTaskGroupIdV1(taskGroupId).thenApply(response -> (ShipperPayCourierLineItemGroup1)response.body());
    }

    public CompletableFuture<ShipperPayCourierLineItemGroup1> byTaskGroupIdV1(String taskGroupId, RequestOptions requestOptions) {
        return this.rawClient.byTaskGroupIdV1(taskGroupId, requestOptions).thenApply(response -> (ShipperPayCourierLineItemGroup1)response.body());
    }

    public CompletableFuture<ShipperPayCourierLineItemGroupServerCreate1> previewV1(ShipperPayCourierLineItemGroupCreateReq request) {
        return this.rawClient.previewV1(request).thenApply(response -> (ShipperPayCourierLineItemGroupServerCreate1)response.body());
    }

    public CompletableFuture<ShipperPayCourierLineItemGroupServerCreate1> previewV1(ShipperPayCourierLineItemGroupCreateReq request, RequestOptions requestOptions) {
        return this.rawClient.previewV1(request, requestOptions).thenApply(response -> (ShipperPayCourierLineItemGroupServerCreate1)response.body());
    }

    public CompletableFuture<String> createV1(ShipperPayCourierLineItemGroupCreateReq request) {
        return this.rawClient.createV1(request).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> createV1(ShipperPayCourierLineItemGroupCreateReq request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).thenApply(response -> (String)response.body());
    }

    public AsyncShipperClient shipper() {
        return this.shipperClient.get();
    }

    public AsyncCourierClient courier() {
        return this.courierClient.get();
    }

    public AsyncAddLineItemsClient addLineItems() {
        return this.addLineItemsClient.get();
    }

    public AsyncRemoveLineItemsClient removeLineItems() {
        return this.removeLineItemsClient.get();
    }
}

