/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.shipperpaycourierlineitemgroups;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.shipperpaycourierlineitemgroups.RawShipperPayCourierLineItemGroupsClient;
import com.chrt.api.resources.shipperpaycourierlineitemgroups.addlineitems.AddLineItemsClient;
import com.chrt.api.resources.shipperpaycourierlineitemgroups.courier.CourierClient;
import com.chrt.api.resources.shipperpaycourierlineitemgroups.removelineitems.RemoveLineItemsClient;
import com.chrt.api.resources.shipperpaycourierlineitemgroups.shipper.ShipperClient;
import com.chrt.api.types.ShipperPayCourierLineItemGroup1;
import com.chrt.api.types.ShipperPayCourierLineItemGroupCreateReq;
import com.chrt.api.types.ShipperPayCourierLineItemGroupServerCreate1;
import java.util.function.Supplier;

public class ShipperPayCourierLineItemGroupsClient {
    protected final ClientOptions clientOptions;
    private final RawShipperPayCourierLineItemGroupsClient rawClient;
    protected final Supplier<ShipperClient> shipperClient;
    protected final Supplier<CourierClient> courierClient;
    protected final Supplier<AddLineItemsClient> addLineItemsClient;
    protected final Supplier<RemoveLineItemsClient> removeLineItemsClient;

    public ShipperPayCourierLineItemGroupsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawShipperPayCourierLineItemGroupsClient(clientOptions);
        this.shipperClient = Suppliers.memoize(() -> new ShipperClient(clientOptions));
        this.courierClient = Suppliers.memoize(() -> new CourierClient(clientOptions));
        this.addLineItemsClient = Suppliers.memoize(() -> new AddLineItemsClient(clientOptions));
        this.removeLineItemsClient = Suppliers.memoize(() -> new RemoveLineItemsClient(clientOptions));
    }

    public RawShipperPayCourierLineItemGroupsClient withRawResponse() {
        return this.rawClient;
    }

    public ShipperPayCourierLineItemGroup1 getByIdV1(String id) {
        return this.rawClient.getByIdV1(id).body();
    }

    public ShipperPayCourierLineItemGroup1 getByIdV1(String id, RequestOptions requestOptions) {
        return this.rawClient.getByIdV1(id, requestOptions).body();
    }

    public boolean deleteByIdV1(String id) {
        return this.rawClient.deleteByIdV1(id).body();
    }

    public boolean deleteByIdV1(String id, RequestOptions requestOptions) {
        return this.rawClient.deleteByIdV1(id, requestOptions).body();
    }

    public ShipperPayCourierLineItemGroup1 byTaskGroupIdV1(String taskGroupId) {
        return this.rawClient.byTaskGroupIdV1(taskGroupId).body();
    }

    public ShipperPayCourierLineItemGroup1 byTaskGroupIdV1(String taskGroupId, RequestOptions requestOptions) {
        return this.rawClient.byTaskGroupIdV1(taskGroupId, requestOptions).body();
    }

    public ShipperPayCourierLineItemGroupServerCreate1 previewV1(ShipperPayCourierLineItemGroupCreateReq request) {
        return this.rawClient.previewV1(request).body();
    }

    public ShipperPayCourierLineItemGroupServerCreate1 previewV1(ShipperPayCourierLineItemGroupCreateReq request, RequestOptions requestOptions) {
        return this.rawClient.previewV1(request, requestOptions).body();
    }

    public String createV1(ShipperPayCourierLineItemGroupCreateReq request) {
        return this.rawClient.createV1(request).body();
    }

    public String createV1(ShipperPayCourierLineItemGroupCreateReq request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).body();
    }

    public ShipperClient shipper() {
        return this.shipperClient.get();
    }

    public CourierClient courier() {
        return this.courierClient.get();
    }

    public AddLineItemsClient addLineItems() {
        return this.addLineItemsClient.get();
    }

    public RemoveLineItemsClient removeLineItems() {
        return this.removeLineItemsClient.get();
    }
}

