/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.shipperpaycourierlineitemgroups.shipper;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.types.HttpValidationError;
import com.chrt.api.types.ShipperPayCourierLineItemGroup1;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.List;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawShipperClient {
    protected final ClientOptions clientOptions;

    public RawShipperClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public ChrtApiHttpResponse<List<ShipperPayCourierLineItemGroup1>> listV1() {
        return this.listV1(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<List<ShipperPayCourierLineItemGroup1>> listV1(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/shipper_pay_courier_line_item_groups/shipper/list/v1").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (!response.isSuccessful()) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            ChrtApiHttpResponse<List<ShipperPayCourierLineItemGroup1>> chrtApiHttpResponse = new ChrtApiHttpResponse<List<ShipperPayCourierLineItemGroup1>>((List)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, (TypeReference)new TypeReference<List<ShipperPayCourierLineItemGroup1>>(){}), response);
            return chrtApiHttpResponse;
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<ShipperPayCourierLineItemGroup1> getByIdV1(String id) {
        return this.getByIdV1(id, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<ShipperPayCourierLineItemGroup1> getByIdV1(String id, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/shipper_pay_courier_line_item_groups/shipper/v1").addPathSegment(id).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<ShipperPayCourierLineItemGroup1> chrtApiHttpResponse = new ChrtApiHttpResponse<ShipperPayCourierLineItemGroup1>((ShipperPayCourierLineItemGroup1)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ShipperPayCourierLineItemGroup1.class), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<ShipperPayCourierLineItemGroup1> byTaskGroupIdV1(String taskGroupId) {
        return this.byTaskGroupIdV1(taskGroupId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<ShipperPayCourierLineItemGroup1> byTaskGroupIdV1(String taskGroupId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/shipper_pay_courier_line_item_groups/shipper/by_task_group/v1").addPathSegment(taskGroupId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<ShipperPayCourierLineItemGroup1> chrtApiHttpResponse = new ChrtApiHttpResponse<ShipperPayCourierLineItemGroup1>((ShipperPayCourierLineItemGroup1)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ShipperPayCourierLineItemGroup1.class), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }
}

