/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.shipperpaycourierratesheets.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.CargoTypeEnum1;
import com.chrt.api.types.RouteTypeEnum1;
import com.chrt.api.types.VehicleTypeEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ShipperPayCourierRateSheetClientCreate1 {
    private final int schemaVersion;
    private final Optional<String> name;
    private final Optional<List<CargoTypeEnum1>> cargoTypes;
    private final Optional<List<VehicleTypeEnum>> vehicleTypes;
    private final Optional<List<RouteTypeEnum1>> routeTypes;
    private final Optional<String> shipperOrgId;
    private final Optional<String> offChrtShipperOrgId;
    private final Optional<String> comments;
    private final double baseMileageDistanceMiles;
    private final double baseMileageRateUsdPerInstance;
    private final double additionalMileageRateUsdPerMile;
    private final double longDistanceSurchargeMilesBeforeSurcharge;
    private final double longDistanceSurchargeRateUsdPerMile;
    private final double fuelSurchargeRateUsdPerMile;
    private final double waitTimeBeforeChargeMinutes;
    private final double waitTimeRateUsdPerMinute;
    private final double extraStopRateUsd;
    private final double dangerousGoodsRateUsdPerInstance;
    private final double afterHours;
    private final double weekend;
    private final double holiday;
    private final Map<String, Object> additionalProperties;

    private ShipperPayCourierRateSheetClientCreate1(int schemaVersion, Optional<String> name, Optional<List<CargoTypeEnum1>> cargoTypes, Optional<List<VehicleTypeEnum>> vehicleTypes, Optional<List<RouteTypeEnum1>> routeTypes, Optional<String> shipperOrgId, Optional<String> offChrtShipperOrgId, Optional<String> comments, double baseMileageDistanceMiles, double baseMileageRateUsdPerInstance, double additionalMileageRateUsdPerMile, double longDistanceSurchargeMilesBeforeSurcharge, double longDistanceSurchargeRateUsdPerMile, double fuelSurchargeRateUsdPerMile, double waitTimeBeforeChargeMinutes, double waitTimeRateUsdPerMinute, double extraStopRateUsd, double dangerousGoodsRateUsdPerInstance, double afterHours, double weekend, double holiday, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.name = name;
        this.cargoTypes = cargoTypes;
        this.vehicleTypes = vehicleTypes;
        this.routeTypes = routeTypes;
        this.shipperOrgId = shipperOrgId;
        this.offChrtShipperOrgId = offChrtShipperOrgId;
        this.comments = comments;
        this.baseMileageDistanceMiles = baseMileageDistanceMiles;
        this.baseMileageRateUsdPerInstance = baseMileageRateUsdPerInstance;
        this.additionalMileageRateUsdPerMile = additionalMileageRateUsdPerMile;
        this.longDistanceSurchargeMilesBeforeSurcharge = longDistanceSurchargeMilesBeforeSurcharge;
        this.longDistanceSurchargeRateUsdPerMile = longDistanceSurchargeRateUsdPerMile;
        this.fuelSurchargeRateUsdPerMile = fuelSurchargeRateUsdPerMile;
        this.waitTimeBeforeChargeMinutes = waitTimeBeforeChargeMinutes;
        this.waitTimeRateUsdPerMinute = waitTimeRateUsdPerMinute;
        this.extraStopRateUsd = extraStopRateUsd;
        this.dangerousGoodsRateUsdPerInstance = dangerousGoodsRateUsdPerInstance;
        this.afterHours = afterHours;
        this.weekend = weekend;
        this.holiday = holiday;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonProperty(value="cargo_types")
    public Optional<List<CargoTypeEnum1>> getCargoTypes() {
        return this.cargoTypes;
    }

    @JsonProperty(value="vehicle_types")
    public Optional<List<VehicleTypeEnum>> getVehicleTypes() {
        return this.vehicleTypes;
    }

    @JsonProperty(value="route_types")
    public Optional<List<RouteTypeEnum1>> getRouteTypes() {
        return this.routeTypes;
    }

    @JsonIgnore
    public Optional<String> getShipperOrgId() {
        if (this.shipperOrgId == null) {
            return Optional.empty();
        }
        return this.shipperOrgId;
    }

    @JsonIgnore
    public Optional<String> getOffChrtShipperOrgId() {
        if (this.offChrtShipperOrgId == null) {
            return Optional.empty();
        }
        return this.offChrtShipperOrgId;
    }

    @JsonIgnore
    public Optional<String> getComments() {
        if (this.comments == null) {
            return Optional.empty();
        }
        return this.comments;
    }

    @JsonProperty(value="base_mileage_distance_miles")
    public double getBaseMileageDistanceMiles() {
        return this.baseMileageDistanceMiles;
    }

    @JsonProperty(value="base_mileage_rate_usd_per_instance")
    public double getBaseMileageRateUsdPerInstance() {
        return this.baseMileageRateUsdPerInstance;
    }

    @JsonProperty(value="additional_mileage_rate_usd_per_mile")
    public double getAdditionalMileageRateUsdPerMile() {
        return this.additionalMileageRateUsdPerMile;
    }

    @JsonProperty(value="long_distance_surcharge_miles_before_surcharge")
    public double getLongDistanceSurchargeMilesBeforeSurcharge() {
        return this.longDistanceSurchargeMilesBeforeSurcharge;
    }

    @JsonProperty(value="long_distance_surcharge_rate_usd_per_mile")
    public double getLongDistanceSurchargeRateUsdPerMile() {
        return this.longDistanceSurchargeRateUsdPerMile;
    }

    @JsonProperty(value="fuel_surcharge_rate_usd_per_mile")
    public double getFuelSurchargeRateUsdPerMile() {
        return this.fuelSurchargeRateUsdPerMile;
    }

    @JsonProperty(value="wait_time_before_charge_minutes")
    public double getWaitTimeBeforeChargeMinutes() {
        return this.waitTimeBeforeChargeMinutes;
    }

    @JsonProperty(value="wait_time_rate_usd_per_minute")
    public double getWaitTimeRateUsdPerMinute() {
        return this.waitTimeRateUsdPerMinute;
    }

    @JsonProperty(value="extra_stop_rate_usd")
    public double getExtraStopRateUsd() {
        return this.extraStopRateUsd;
    }

    @JsonProperty(value="dangerous_goods_rate_usd_per_instance")
    public double getDangerousGoodsRateUsdPerInstance() {
        return this.dangerousGoodsRateUsdPerInstance;
    }

    @JsonProperty(value="after_hours")
    public double getAfterHours() {
        return this.afterHours;
    }

    @JsonProperty(value="weekend")
    public double getWeekend() {
        return this.weekend;
    }

    @JsonProperty(value="holiday")
    public double getHoliday() {
        return this.holiday;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="shipper_org_id")
    private Optional<String> _getShipperOrgId() {
        return this.shipperOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="off_chrt_shipper_org_id")
    private Optional<String> _getOffChrtShipperOrgId() {
        return this.offChrtShipperOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="comments")
    private Optional<String> _getComments() {
        return this.comments;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ShipperPayCourierRateSheetClientCreate1 && this.equalTo((ShipperPayCourierRateSheetClientCreate1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ShipperPayCourierRateSheetClientCreate1 other) {
        return this.schemaVersion == other.schemaVersion && this.name.equals(other.name) && this.cargoTypes.equals(other.cargoTypes) && this.vehicleTypes.equals(other.vehicleTypes) && this.routeTypes.equals(other.routeTypes) && this.shipperOrgId.equals(other.shipperOrgId) && this.offChrtShipperOrgId.equals(other.offChrtShipperOrgId) && this.comments.equals(other.comments) && this.baseMileageDistanceMiles == other.baseMileageDistanceMiles && this.baseMileageRateUsdPerInstance == other.baseMileageRateUsdPerInstance && this.additionalMileageRateUsdPerMile == other.additionalMileageRateUsdPerMile && this.longDistanceSurchargeMilesBeforeSurcharge == other.longDistanceSurchargeMilesBeforeSurcharge && this.longDistanceSurchargeRateUsdPerMile == other.longDistanceSurchargeRateUsdPerMile && this.fuelSurchargeRateUsdPerMile == other.fuelSurchargeRateUsdPerMile && this.waitTimeBeforeChargeMinutes == other.waitTimeBeforeChargeMinutes && this.waitTimeRateUsdPerMinute == other.waitTimeRateUsdPerMinute && this.extraStopRateUsd == other.extraStopRateUsd && this.dangerousGoodsRateUsdPerInstance == other.dangerousGoodsRateUsdPerInstance && this.afterHours == other.afterHours && this.weekend == other.weekend && this.holiday == other.holiday;
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.name, this.cargoTypes, this.vehicleTypes, this.routeTypes, this.shipperOrgId, this.offChrtShipperOrgId, this.comments, this.baseMileageDistanceMiles, this.baseMileageRateUsdPerInstance, this.additionalMileageRateUsdPerMile, this.longDistanceSurchargeMilesBeforeSurcharge, this.longDistanceSurchargeRateUsdPerMile, this.fuelSurchargeRateUsdPerMile, this.waitTimeBeforeChargeMinutes, this.waitTimeRateUsdPerMinute, this.extraStopRateUsd, this.dangerousGoodsRateUsdPerInstance, this.afterHours, this.weekend, this.holiday);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    BaseMileageDistanceMilesStage,
    BaseMileageRateUsdPerInstanceStage,
    AdditionalMileageRateUsdPerMileStage,
    LongDistanceSurchargeMilesBeforeSurchargeStage,
    LongDistanceSurchargeRateUsdPerMileStage,
    FuelSurchargeRateUsdPerMileStage,
    WaitTimeBeforeChargeMinutesStage,
    WaitTimeRateUsdPerMinuteStage,
    ExtraStopRateUsdStage,
    DangerousGoodsRateUsdPerInstanceStage,
    AfterHoursStage,
    WeekendStage,
    HolidayStage,
    _FinalStage {
        private int schemaVersion;
        private double baseMileageDistanceMiles;
        private double baseMileageRateUsdPerInstance;
        private double additionalMileageRateUsdPerMile;
        private double longDistanceSurchargeMilesBeforeSurcharge;
        private double longDistanceSurchargeRateUsdPerMile;
        private double fuelSurchargeRateUsdPerMile;
        private double waitTimeBeforeChargeMinutes;
        private double waitTimeRateUsdPerMinute;
        private double extraStopRateUsd;
        private double dangerousGoodsRateUsdPerInstance;
        private double afterHours;
        private double weekend;
        private double holiday;
        private Optional<String> comments = Optional.empty();
        private Optional<String> offChrtShipperOrgId = Optional.empty();
        private Optional<String> shipperOrgId = Optional.empty();
        private Optional<List<RouteTypeEnum1>> routeTypes = Optional.empty();
        private Optional<List<VehicleTypeEnum>> vehicleTypes = Optional.empty();
        private Optional<List<CargoTypeEnum1>> cargoTypes = Optional.empty();
        private Optional<String> name = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ShipperPayCourierRateSheetClientCreate1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.name(other.getName());
            this.cargoTypes(other.getCargoTypes());
            this.vehicleTypes(other.getVehicleTypes());
            this.routeTypes(other.getRouteTypes());
            this.shipperOrgId(other.getShipperOrgId());
            this.offChrtShipperOrgId(other.getOffChrtShipperOrgId());
            this.comments(other.getComments());
            this.baseMileageDistanceMiles(other.getBaseMileageDistanceMiles());
            this.baseMileageRateUsdPerInstance(other.getBaseMileageRateUsdPerInstance());
            this.additionalMileageRateUsdPerMile(other.getAdditionalMileageRateUsdPerMile());
            this.longDistanceSurchargeMilesBeforeSurcharge(other.getLongDistanceSurchargeMilesBeforeSurcharge());
            this.longDistanceSurchargeRateUsdPerMile(other.getLongDistanceSurchargeRateUsdPerMile());
            this.fuelSurchargeRateUsdPerMile(other.getFuelSurchargeRateUsdPerMile());
            this.waitTimeBeforeChargeMinutes(other.getWaitTimeBeforeChargeMinutes());
            this.waitTimeRateUsdPerMinute(other.getWaitTimeRateUsdPerMinute());
            this.extraStopRateUsd(other.getExtraStopRateUsd());
            this.dangerousGoodsRateUsdPerInstance(other.getDangerousGoodsRateUsdPerInstance());
            this.afterHours(other.getAfterHours());
            this.weekend(other.getWeekend());
            this.holiday(other.getHoliday());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public BaseMileageDistanceMilesStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="base_mileage_distance_miles")
        public BaseMileageRateUsdPerInstanceStage baseMileageDistanceMiles(double baseMileageDistanceMiles) {
            this.baseMileageDistanceMiles = baseMileageDistanceMiles;
            return this;
        }

        @Override
        @JsonSetter(value="base_mileage_rate_usd_per_instance")
        public AdditionalMileageRateUsdPerMileStage baseMileageRateUsdPerInstance(double baseMileageRateUsdPerInstance) {
            this.baseMileageRateUsdPerInstance = baseMileageRateUsdPerInstance;
            return this;
        }

        @Override
        @JsonSetter(value="additional_mileage_rate_usd_per_mile")
        public LongDistanceSurchargeMilesBeforeSurchargeStage additionalMileageRateUsdPerMile(double additionalMileageRateUsdPerMile) {
            this.additionalMileageRateUsdPerMile = additionalMileageRateUsdPerMile;
            return this;
        }

        @Override
        @JsonSetter(value="long_distance_surcharge_miles_before_surcharge")
        public LongDistanceSurchargeRateUsdPerMileStage longDistanceSurchargeMilesBeforeSurcharge(double longDistanceSurchargeMilesBeforeSurcharge) {
            this.longDistanceSurchargeMilesBeforeSurcharge = longDistanceSurchargeMilesBeforeSurcharge;
            return this;
        }

        @Override
        @JsonSetter(value="long_distance_surcharge_rate_usd_per_mile")
        public FuelSurchargeRateUsdPerMileStage longDistanceSurchargeRateUsdPerMile(double longDistanceSurchargeRateUsdPerMile) {
            this.longDistanceSurchargeRateUsdPerMile = longDistanceSurchargeRateUsdPerMile;
            return this;
        }

        @Override
        @JsonSetter(value="fuel_surcharge_rate_usd_per_mile")
        public WaitTimeBeforeChargeMinutesStage fuelSurchargeRateUsdPerMile(double fuelSurchargeRateUsdPerMile) {
            this.fuelSurchargeRateUsdPerMile = fuelSurchargeRateUsdPerMile;
            return this;
        }

        @Override
        @JsonSetter(value="wait_time_before_charge_minutes")
        public WaitTimeRateUsdPerMinuteStage waitTimeBeforeChargeMinutes(double waitTimeBeforeChargeMinutes) {
            this.waitTimeBeforeChargeMinutes = waitTimeBeforeChargeMinutes;
            return this;
        }

        @Override
        @JsonSetter(value="wait_time_rate_usd_per_minute")
        public ExtraStopRateUsdStage waitTimeRateUsdPerMinute(double waitTimeRateUsdPerMinute) {
            this.waitTimeRateUsdPerMinute = waitTimeRateUsdPerMinute;
            return this;
        }

        @Override
        @JsonSetter(value="extra_stop_rate_usd")
        public DangerousGoodsRateUsdPerInstanceStage extraStopRateUsd(double extraStopRateUsd) {
            this.extraStopRateUsd = extraStopRateUsd;
            return this;
        }

        @Override
        @JsonSetter(value="dangerous_goods_rate_usd_per_instance")
        public AfterHoursStage dangerousGoodsRateUsdPerInstance(double dangerousGoodsRateUsdPerInstance) {
            this.dangerousGoodsRateUsdPerInstance = dangerousGoodsRateUsdPerInstance;
            return this;
        }

        @Override
        @JsonSetter(value="after_hours")
        public WeekendStage afterHours(double afterHours) {
            this.afterHours = afterHours;
            return this;
        }

        @Override
        @JsonSetter(value="weekend")
        public HolidayStage weekend(double weekend) {
            this.weekend = weekend;
            return this;
        }

        @Override
        @JsonSetter(value="holiday")
        public _FinalStage holiday(double holiday) {
            this.holiday = holiday;
            return this;
        }

        @Override
        public _FinalStage comments(Nullable<String> comments) {
            this.comments = comments.isNull() ? null : (comments.isEmpty() ? Optional.empty() : Optional.of(comments.get()));
            return this;
        }

        @Override
        public _FinalStage comments(String comments) {
            this.comments = Optional.ofNullable(comments);
            return this;
        }

        @Override
        @JsonSetter(value="comments", nulls=Nulls.SKIP)
        public _FinalStage comments(Optional<String> comments) {
            this.comments = comments;
            return this;
        }

        @Override
        public _FinalStage offChrtShipperOrgId(Nullable<String> offChrtShipperOrgId) {
            this.offChrtShipperOrgId = offChrtShipperOrgId.isNull() ? null : (offChrtShipperOrgId.isEmpty() ? Optional.empty() : Optional.of(offChrtShipperOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage offChrtShipperOrgId(String offChrtShipperOrgId) {
            this.offChrtShipperOrgId = Optional.ofNullable(offChrtShipperOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="off_chrt_shipper_org_id", nulls=Nulls.SKIP)
        public _FinalStage offChrtShipperOrgId(Optional<String> offChrtShipperOrgId) {
            this.offChrtShipperOrgId = offChrtShipperOrgId;
            return this;
        }

        @Override
        public _FinalStage shipperOrgId(Nullable<String> shipperOrgId) {
            this.shipperOrgId = shipperOrgId.isNull() ? null : (shipperOrgId.isEmpty() ? Optional.empty() : Optional.of(shipperOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage shipperOrgId(String shipperOrgId) {
            this.shipperOrgId = Optional.ofNullable(shipperOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="shipper_org_id", nulls=Nulls.SKIP)
        public _FinalStage shipperOrgId(Optional<String> shipperOrgId) {
            this.shipperOrgId = shipperOrgId;
            return this;
        }

        @Override
        public _FinalStage routeTypes(List<RouteTypeEnum1> routeTypes) {
            this.routeTypes = Optional.ofNullable(routeTypes);
            return this;
        }

        @Override
        @JsonSetter(value="route_types", nulls=Nulls.SKIP)
        public _FinalStage routeTypes(Optional<List<RouteTypeEnum1>> routeTypes) {
            this.routeTypes = routeTypes;
            return this;
        }

        @Override
        public _FinalStage vehicleTypes(List<VehicleTypeEnum> vehicleTypes) {
            this.vehicleTypes = Optional.ofNullable(vehicleTypes);
            return this;
        }

        @Override
        @JsonSetter(value="vehicle_types", nulls=Nulls.SKIP)
        public _FinalStage vehicleTypes(Optional<List<VehicleTypeEnum>> vehicleTypes) {
            this.vehicleTypes = vehicleTypes;
            return this;
        }

        @Override
        public _FinalStage cargoTypes(List<CargoTypeEnum1> cargoTypes) {
            this.cargoTypes = Optional.ofNullable(cargoTypes);
            return this;
        }

        @Override
        @JsonSetter(value="cargo_types", nulls=Nulls.SKIP)
        public _FinalStage cargoTypes(Optional<List<CargoTypeEnum1>> cargoTypes) {
            this.cargoTypes = cargoTypes;
            return this;
        }

        @Override
        public _FinalStage name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public ShipperPayCourierRateSheetClientCreate1 build() {
            return new ShipperPayCourierRateSheetClientCreate1(this.schemaVersion, this.name, this.cargoTypes, this.vehicleTypes, this.routeTypes, this.shipperOrgId, this.offChrtShipperOrgId, this.comments, this.baseMileageDistanceMiles, this.baseMileageRateUsdPerInstance, this.additionalMileageRateUsdPerMile, this.longDistanceSurchargeMilesBeforeSurcharge, this.longDistanceSurchargeRateUsdPerMile, this.fuelSurchargeRateUsdPerMile, this.waitTimeBeforeChargeMinutes, this.waitTimeRateUsdPerMinute, this.extraStopRateUsd, this.dangerousGoodsRateUsdPerInstance, this.afterHours, this.weekend, this.holiday, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ShipperPayCourierRateSheetClientCreate1 build();

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage name(Nullable<String> var1);

        public _FinalStage cargoTypes(Optional<List<CargoTypeEnum1>> var1);

        public _FinalStage cargoTypes(List<CargoTypeEnum1> var1);

        public _FinalStage vehicleTypes(Optional<List<VehicleTypeEnum>> var1);

        public _FinalStage vehicleTypes(List<VehicleTypeEnum> var1);

        public _FinalStage routeTypes(Optional<List<RouteTypeEnum1>> var1);

        public _FinalStage routeTypes(List<RouteTypeEnum1> var1);

        public _FinalStage shipperOrgId(Optional<String> var1);

        public _FinalStage shipperOrgId(String var1);

        public _FinalStage shipperOrgId(Nullable<String> var1);

        public _FinalStage offChrtShipperOrgId(Optional<String> var1);

        public _FinalStage offChrtShipperOrgId(String var1);

        public _FinalStage offChrtShipperOrgId(Nullable<String> var1);

        public _FinalStage comments(Optional<String> var1);

        public _FinalStage comments(String var1);

        public _FinalStage comments(Nullable<String> var1);
    }

    public static interface HolidayStage {
        public _FinalStage holiday(double var1);
    }

    public static interface WeekendStage {
        public HolidayStage weekend(double var1);
    }

    public static interface AfterHoursStage {
        public WeekendStage afterHours(double var1);
    }

    public static interface DangerousGoodsRateUsdPerInstanceStage {
        public AfterHoursStage dangerousGoodsRateUsdPerInstance(double var1);
    }

    public static interface ExtraStopRateUsdStage {
        public DangerousGoodsRateUsdPerInstanceStage extraStopRateUsd(double var1);
    }

    public static interface WaitTimeRateUsdPerMinuteStage {
        public ExtraStopRateUsdStage waitTimeRateUsdPerMinute(double var1);
    }

    public static interface WaitTimeBeforeChargeMinutesStage {
        public WaitTimeRateUsdPerMinuteStage waitTimeBeforeChargeMinutes(double var1);
    }

    public static interface FuelSurchargeRateUsdPerMileStage {
        public WaitTimeBeforeChargeMinutesStage fuelSurchargeRateUsdPerMile(double var1);
    }

    public static interface LongDistanceSurchargeRateUsdPerMileStage {
        public FuelSurchargeRateUsdPerMileStage longDistanceSurchargeRateUsdPerMile(double var1);
    }

    public static interface LongDistanceSurchargeMilesBeforeSurchargeStage {
        public LongDistanceSurchargeRateUsdPerMileStage longDistanceSurchargeMilesBeforeSurcharge(double var1);
    }

    public static interface AdditionalMileageRateUsdPerMileStage {
        public LongDistanceSurchargeMilesBeforeSurchargeStage additionalMileageRateUsdPerMile(double var1);
    }

    public static interface BaseMileageRateUsdPerInstanceStage {
        public AdditionalMileageRateUsdPerMileStage baseMileageRateUsdPerInstance(double var1);
    }

    public static interface BaseMileageDistanceMilesStage {
        public BaseMileageRateUsdPerInstanceStage baseMileageDistanceMiles(double var1);
    }

    public static interface SchemaVersionStage {
        public BaseMileageDistanceMilesStage schemaVersion(int var1);

        public Builder from(ShipperPayCourierRateSheetClientCreate1 var1);
    }
}

