/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.taskartifacts;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.taskartifacts.RawTaskArtifactsClient;
import com.chrt.api.resources.taskartifacts.requests.AddTaskArtifactReq;
import com.chrt.api.resources.taskartifacts.s3object.S3ObjectClient;
import java.util.function.Supplier;

public class TaskArtifactsClient {
    protected final ClientOptions clientOptions;
    private final RawTaskArtifactsClient rawClient;
    protected final Supplier<S3ObjectClient> s3ObjectClient;

    public TaskArtifactsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawTaskArtifactsClient(clientOptions);
        this.s3ObjectClient = Suppliers.memoize(() -> new S3ObjectClient(clientOptions));
    }

    public RawTaskArtifactsClient withRawResponse() {
        return this.rawClient;
    }

    public String addToTaskV1(String taskId, AddTaskArtifactReq request) {
        return this.rawClient.addToTaskV1(taskId, request).body();
    }

    public String addToTaskV1(String taskId, AddTaskArtifactReq request, RequestOptions requestOptions) {
        return this.rawClient.addToTaskV1(taskId, request, requestOptions).body();
    }

    public boolean completeV1(String taskArtifactId) {
        return this.rawClient.completeV1(taskArtifactId).body();
    }

    public boolean completeV1(String taskArtifactId, RequestOptions requestOptions) {
        return this.rawClient.completeV1(taskArtifactId, requestOptions).body();
    }

    public boolean skipV1(String taskArtifactId) {
        return this.rawClient.skipV1(taskArtifactId).body();
    }

    public boolean skipV1(String taskArtifactId, RequestOptions requestOptions) {
        return this.rawClient.skipV1(taskArtifactId, requestOptions).body();
    }

    public boolean deleteV1(String taskArtifactId) {
        return this.rawClient.deleteV1(taskArtifactId).body();
    }

    public boolean deleteV1(String taskArtifactId, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(taskArtifactId, requestOptions).body();
    }

    public S3ObjectClient s3Object() {
        return this.s3ObjectClient.get();
    }
}

