/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.taskgroups;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.taskgroups.AsyncRawTaskGroupsClient;
import com.chrt.api.resources.taskgroups.expanded.AsyncExpandedClient;
import com.chrt.api.resources.taskgroups.requests.AddMessageReq;
import com.chrt.api.resources.taskgroups.requests.SetFlightNumberReq;
import com.chrt.api.resources.taskgroups.requests.SetTaskOrderingReq;
import com.chrt.api.resources.taskgroups.requests.UpdateCourierOrgReq;
import com.chrt.api.resources.taskgroups.requests.UpdateDriverReq;
import com.chrt.api.resources.taskgroups.s3object.AsyncS3ObjectClient;
import com.chrt.api.resources.taskgroups.taskgroupid.AsyncTaskGroupIdClient;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncTaskGroupsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawTaskGroupsClient rawClient;
    protected final Supplier<AsyncTaskGroupIdClient> taskGroupIdClient;
    protected final Supplier<AsyncS3ObjectClient> s3ObjectClient;
    protected final Supplier<AsyncExpandedClient> expandedClient;

    public AsyncTaskGroupsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTaskGroupsClient(clientOptions);
        this.taskGroupIdClient = Suppliers.memoize(() -> new AsyncTaskGroupIdClient(clientOptions));
        this.s3ObjectClient = Suppliers.memoize(() -> new AsyncS3ObjectClient(clientOptions));
        this.expandedClient = Suppliers.memoize(() -> new AsyncExpandedClient(clientOptions));
    }

    public AsyncRawTaskGroupsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<Boolean> startV1(String taskGroupId) {
        return this.rawClient.startV1(taskGroupId).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> startV1(String taskGroupId, RequestOptions requestOptions) {
        return this.rawClient.startV1(taskGroupId, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> setTaskOrderingV1(String taskGroupId, SetTaskOrderingReq request) {
        return this.rawClient.setTaskOrderingV1(taskGroupId, request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> setTaskOrderingV1(String taskGroupId, SetTaskOrderingReq request, RequestOptions requestOptions) {
        return this.rawClient.setTaskOrderingV1(taskGroupId, request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> setFlightNumberV1(String taskGroupId, SetFlightNumberReq request) {
        return this.rawClient.setFlightNumberV1(taskGroupId, request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> setFlightNumberV1(String taskGroupId, SetFlightNumberReq request, RequestOptions requestOptions) {
        return this.rawClient.setFlightNumberV1(taskGroupId, request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateDriverV1(String taskGroupId, UpdateDriverReq request) {
        return this.rawClient.updateDriverV1(taskGroupId, request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateDriverV1(String taskGroupId, UpdateDriverReq request, RequestOptions requestOptions) {
        return this.rawClient.updateDriverV1(taskGroupId, request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> removeDriverV1(String taskGroupId) {
        return this.rawClient.removeDriverV1(taskGroupId).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> removeDriverV1(String taskGroupId, RequestOptions requestOptions) {
        return this.rawClient.removeDriverV1(taskGroupId, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateCourierOrgV1(String taskGroupId, UpdateCourierOrgReq request) {
        return this.rawClient.updateCourierOrgV1(taskGroupId, request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateCourierOrgV1(String taskGroupId, UpdateCourierOrgReq request, RequestOptions requestOptions) {
        return this.rawClient.updateCourierOrgV1(taskGroupId, request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> addMessageV1(String taskGroupId, AddMessageReq request) {
        return this.rawClient.addMessageV1(taskGroupId, request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> addMessageV1(String taskGroupId, AddMessageReq request, RequestOptions requestOptions) {
        return this.rawClient.addMessageV1(taskGroupId, request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public AsyncTaskGroupIdClient taskGroupId() {
        return this.taskGroupIdClient.get();
    }

    public AsyncS3ObjectClient s3Object() {
        return this.s3ObjectClient.get();
    }

    public AsyncExpandedClient expanded() {
        return this.expandedClient.get();
    }
}

