/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.taskgroups;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.taskgroups.RawTaskGroupsClient;
import com.chrt.api.resources.taskgroups.expanded.ExpandedClient;
import com.chrt.api.resources.taskgroups.requests.AddMessageReq;
import com.chrt.api.resources.taskgroups.requests.SetFlightNumberReq;
import com.chrt.api.resources.taskgroups.requests.SetTaskOrderingReq;
import com.chrt.api.resources.taskgroups.requests.UpdateCourierOrgReq;
import com.chrt.api.resources.taskgroups.requests.UpdateDriverReq;
import com.chrt.api.resources.taskgroups.s3object.S3ObjectClient;
import com.chrt.api.resources.taskgroups.taskgroupid.TaskGroupIdClient;
import java.util.function.Supplier;

public class TaskGroupsClient {
    protected final ClientOptions clientOptions;
    private final RawTaskGroupsClient rawClient;
    protected final Supplier<TaskGroupIdClient> taskGroupIdClient;
    protected final Supplier<S3ObjectClient> s3ObjectClient;
    protected final Supplier<ExpandedClient> expandedClient;

    public TaskGroupsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawTaskGroupsClient(clientOptions);
        this.taskGroupIdClient = Suppliers.memoize(() -> new TaskGroupIdClient(clientOptions));
        this.s3ObjectClient = Suppliers.memoize(() -> new S3ObjectClient(clientOptions));
        this.expandedClient = Suppliers.memoize(() -> new ExpandedClient(clientOptions));
    }

    public RawTaskGroupsClient withRawResponse() {
        return this.rawClient;
    }

    public boolean startV1(String taskGroupId) {
        return this.rawClient.startV1(taskGroupId).body();
    }

    public boolean startV1(String taskGroupId, RequestOptions requestOptions) {
        return this.rawClient.startV1(taskGroupId, requestOptions).body();
    }

    public boolean setTaskOrderingV1(String taskGroupId, SetTaskOrderingReq request) {
        return this.rawClient.setTaskOrderingV1(taskGroupId, request).body();
    }

    public boolean setTaskOrderingV1(String taskGroupId, SetTaskOrderingReq request, RequestOptions requestOptions) {
        return this.rawClient.setTaskOrderingV1(taskGroupId, request, requestOptions).body();
    }

    public boolean setFlightNumberV1(String taskGroupId, SetFlightNumberReq request) {
        return this.rawClient.setFlightNumberV1(taskGroupId, request).body();
    }

    public boolean setFlightNumberV1(String taskGroupId, SetFlightNumberReq request, RequestOptions requestOptions) {
        return this.rawClient.setFlightNumberV1(taskGroupId, request, requestOptions).body();
    }

    public boolean updateDriverV1(String taskGroupId, UpdateDriverReq request) {
        return this.rawClient.updateDriverV1(taskGroupId, request).body();
    }

    public boolean updateDriverV1(String taskGroupId, UpdateDriverReq request, RequestOptions requestOptions) {
        return this.rawClient.updateDriverV1(taskGroupId, request, requestOptions).body();
    }

    public boolean removeDriverV1(String taskGroupId) {
        return this.rawClient.removeDriverV1(taskGroupId).body();
    }

    public boolean removeDriverV1(String taskGroupId, RequestOptions requestOptions) {
        return this.rawClient.removeDriverV1(taskGroupId, requestOptions).body();
    }

    public boolean updateCourierOrgV1(String taskGroupId, UpdateCourierOrgReq request) {
        return this.rawClient.updateCourierOrgV1(taskGroupId, request).body();
    }

    public boolean updateCourierOrgV1(String taskGroupId, UpdateCourierOrgReq request, RequestOptions requestOptions) {
        return this.rawClient.updateCourierOrgV1(taskGroupId, request, requestOptions).body();
    }

    public boolean addMessageV1(String taskGroupId, AddMessageReq request) {
        return this.rawClient.addMessageV1(taskGroupId, request).body();
    }

    public boolean addMessageV1(String taskGroupId, AddMessageReq request, RequestOptions requestOptions) {
        return this.rawClient.addMessageV1(taskGroupId, request, requestOptions).body();
    }

    public TaskGroupIdClient taskGroupId() {
        return this.taskGroupIdClient.get();
    }

    public S3ObjectClient s3Object() {
        return this.s3ObjectClient.get();
    }

    public ExpandedClient expanded() {
        return this.expandedClient.get();
    }
}

