/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.taskgroups.taskgroupid;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.types.HttpValidationError;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawTaskGroupIdClient {
    protected final ClientOptions clientOptions;

    public AsyncRawTaskGroupIdClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public CompletableFuture<ChrtApiHttpResponse<String>> forCourierOperatorsV1(String orderIdOrShortId) {
        return this.forCourierOperatorsV1(orderIdOrShortId, null);
    }

    public CompletableFuture<ChrtApiHttpResponse<String>> forCourierOperatorsV1(String orderIdOrShortId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/task_groups/task_group_id/for_courier_operators/v1").addPathSegment(orderIdOrShortId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<ChrtApiHttpResponse<String>> future = new CompletableFuture<ChrtApiHttpResponse<String>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            /*
             * Loose catch block
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try {
                    String responseBodyString;
                    ResponseBody responseBody;
                    block13: {
                        block14: {
                            block11: {
                                block12: {
                                    responseBody = response.body();
                                    String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
                                    if (!response.isSuccessful()) break block11;
                                    future.complete(new ChrtApiHttpResponse<String>((String)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, String.class), response));
                                    if (responseBody == null) break block12;
                                    responseBody.close();
                                }
                                return;
                            }
                            if (response.code() != 422) break block13;
                            future.completeExceptionally(new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response));
                            if (responseBody == null) break block14;
                            responseBody.close();
                        }
                        return;
                    }
                    try {
                        block15: {
                            break block15;
                            catch (JsonProcessingException jsonProcessingException) {
                                // empty catch block
                            }
                        }
                        future.completeExceptionally(new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                        return;
                    }
                    finally {
                        if (responseBody != null) {
                            responseBody.close();
                        }
                    }
                }
                catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<ChrtApiHttpResponse<String>> forCourierDriverV1(String orderIdOrShortId) {
        return this.forCourierDriverV1(orderIdOrShortId, null);
    }

    public CompletableFuture<ChrtApiHttpResponse<String>> forCourierDriverV1(String orderIdOrShortId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/task_groups/task_group_id/for_courier_driver/v1").addPathSegment(orderIdOrShortId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<ChrtApiHttpResponse<String>> future = new CompletableFuture<ChrtApiHttpResponse<String>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            /*
             * Loose catch block
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try {
                    String responseBodyString;
                    ResponseBody responseBody;
                    block13: {
                        block14: {
                            block11: {
                                block12: {
                                    responseBody = response.body();
                                    String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
                                    if (!response.isSuccessful()) break block11;
                                    future.complete(new ChrtApiHttpResponse<String>((String)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, String.class), response));
                                    if (responseBody == null) break block12;
                                    responseBody.close();
                                }
                                return;
                            }
                            if (response.code() != 422) break block13;
                            future.completeExceptionally(new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response));
                            if (responseBody == null) break block14;
                            responseBody.close();
                        }
                        return;
                    }
                    try {
                        block15: {
                            break block15;
                            catch (JsonProcessingException jsonProcessingException) {
                                // empty catch block
                            }
                        }
                        future.completeExceptionally(new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                        return;
                    }
                    finally {
                        if (responseBody != null) {
                            responseBody.close();
                        }
                    }
                }
                catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}

