/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.tracking;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.tracking.devices.AsyncDevicesClient;
import com.chrt.api.resources.tracking.driver.AsyncDriverClient;
import com.chrt.api.resources.tracking.sessions.AsyncSessionsClient;
import com.chrt.api.resources.tracking.sharing.AsyncSharingClient;
import com.chrt.api.resources.tracking.timeseries.AsyncTimeseriesClient;
import java.util.function.Supplier;

public class AsyncTrackingClient {
    protected final ClientOptions clientOptions;
    protected final Supplier<AsyncDevicesClient> devicesClient;
    protected final Supplier<AsyncDriverClient> driverClient;
    protected final Supplier<AsyncSessionsClient> sessionsClient;
    protected final Supplier<AsyncSharingClient> sharingClient;
    protected final Supplier<AsyncTimeseriesClient> timeseriesClient;

    public AsyncTrackingClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.devicesClient = Suppliers.memoize(() -> new AsyncDevicesClient(clientOptions));
        this.driverClient = Suppliers.memoize(() -> new AsyncDriverClient(clientOptions));
        this.sessionsClient = Suppliers.memoize(() -> new AsyncSessionsClient(clientOptions));
        this.sharingClient = Suppliers.memoize(() -> new AsyncSharingClient(clientOptions));
        this.timeseriesClient = Suppliers.memoize(() -> new AsyncTimeseriesClient(clientOptions));
    }

    public AsyncDevicesClient devices() {
        return this.devicesClient.get();
    }

    public AsyncDriverClient driver() {
        return this.driverClient.get();
    }

    public AsyncSessionsClient sessions() {
        return this.sessionsClient.get();
    }

    public AsyncSharingClient sharing() {
        return this.sharingClient.get();
    }

    public AsyncTimeseriesClient timeseries() {
        return this.timeseriesClient.get();
    }
}

