/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.tracking;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.tracking.devices.DevicesClient;
import com.chrt.api.resources.tracking.driver.DriverClient;
import com.chrt.api.resources.tracking.sessions.SessionsClient;
import com.chrt.api.resources.tracking.sharing.SharingClient;
import com.chrt.api.resources.tracking.timeseries.TimeseriesClient;
import java.util.function.Supplier;

public class TrackingClient {
    protected final ClientOptions clientOptions;
    protected final Supplier<DevicesClient> devicesClient;
    protected final Supplier<DriverClient> driverClient;
    protected final Supplier<SessionsClient> sessionsClient;
    protected final Supplier<SharingClient> sharingClient;
    protected final Supplier<TimeseriesClient> timeseriesClient;

    public TrackingClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.devicesClient = Suppliers.memoize(() -> new DevicesClient(clientOptions));
        this.driverClient = Suppliers.memoize(() -> new DriverClient(clientOptions));
        this.sessionsClient = Suppliers.memoize(() -> new SessionsClient(clientOptions));
        this.sharingClient = Suppliers.memoize(() -> new SharingClient(clientOptions));
        this.timeseriesClient = Suppliers.memoize(() -> new TimeseriesClient(clientOptions));
    }

    public DevicesClient devices() {
        return this.devicesClient.get();
    }

    public DriverClient driver() {
        return this.driverClient.get();
    }

    public SessionsClient sessions() {
        return this.sessionsClient.get();
    }

    public SharingClient sharing() {
        return this.sharingClient.get();
    }

    public TimeseriesClient timeseries() {
        return this.timeseriesClient.get();
    }
}

