/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.tracking.devices;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.tracking.devices.AsyncRawDevicesClient;
import com.chrt.api.resources.tracking.devices.requests.DevicesDeleteV1Request;
import com.chrt.api.resources.tracking.devices.requests.DevicesGetV1Request;
import com.chrt.api.resources.tracking.devices.requests.DevicesLinkToCargoV1Request;
import com.chrt.api.resources.tracking.devices.requests.DevicesRegisterToOrgReq1;
import com.chrt.api.resources.tracking.devices.requests.DevicesUnlinkFromCargoV1Request;
import com.chrt.api.resources.tracking.devices.requests.DevicesUpdateRequest1;
import com.chrt.api.types.Device1;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncDevicesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawDevicesClient rawClient;

    public AsyncDevicesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawDevicesClient(clientOptions);
    }

    public AsyncRawDevicesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<String> registerToOrgV1(DevicesRegisterToOrgReq1 request) {
        return this.rawClient.registerToOrgV1(request).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> registerToOrgV1(DevicesRegisterToOrgReq1 request, RequestOptions requestOptions) {
        return this.rawClient.registerToOrgV1(request, requestOptions).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<Boolean> updateV1() {
        return this.rawClient.updateV1().thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateV1(DevicesUpdateRequest1 request) {
        return this.rawClient.updateV1(request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateV1(DevicesUpdateRequest1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> deleteV1() {
        return this.rawClient.deleteV1().thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> deleteV1(DevicesDeleteV1Request request) {
        return this.rawClient.deleteV1(request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> deleteV1(DevicesDeleteV1Request request, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> linkToCargoV1(DevicesLinkToCargoV1Request request) {
        return this.rawClient.linkToCargoV1(request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> linkToCargoV1(DevicesLinkToCargoV1Request request, RequestOptions requestOptions) {
        return this.rawClient.linkToCargoV1(request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> unlinkFromCargoV1(DevicesUnlinkFromCargoV1Request request) {
        return this.rawClient.unlinkFromCargoV1(request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> unlinkFromCargoV1(DevicesUnlinkFromCargoV1Request request, RequestOptions requestOptions) {
        return this.rawClient.unlinkFromCargoV1(request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Device1> getV1() {
        return this.rawClient.getV1().thenApply(response -> (Device1)response.body());
    }

    public CompletableFuture<Device1> getV1(DevicesGetV1Request request) {
        return this.rawClient.getV1(request).thenApply(response -> (Device1)response.body());
    }

    public CompletableFuture<Device1> getV1(DevicesGetV1Request request, RequestOptions requestOptions) {
        return this.rawClient.getV1(request, requestOptions).thenApply(response -> (Device1)response.body());
    }

    public CompletableFuture<List<Device1>> listV1() {
        return this.rawClient.listV1().thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<Device1>> listV1(RequestOptions requestOptions) {
        return this.rawClient.listV1(requestOptions).thenApply(response -> (List)response.body());
    }
}

