/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.tracking.devices.requests;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DevicesLinkToCargoV1Request {
    private final String deviceMacAddress;
    private final String cargoId;
    private final Map<String, Object> additionalProperties;

    private DevicesLinkToCargoV1Request(String deviceMacAddress, String cargoId, Map<String, Object> additionalProperties) {
        this.deviceMacAddress = deviceMacAddress;
        this.cargoId = cargoId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="device_mac_address")
    public String getDeviceMacAddress() {
        return this.deviceMacAddress;
    }

    @JsonProperty(value="cargo_id")
    public String getCargoId() {
        return this.cargoId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DevicesLinkToCargoV1Request && this.equalTo((DevicesLinkToCargoV1Request)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DevicesLinkToCargoV1Request other) {
        return this.deviceMacAddress.equals(other.deviceMacAddress) && this.cargoId.equals(other.cargoId);
    }

    public int hashCode() {
        return Objects.hash(this.deviceMacAddress, this.cargoId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DeviceMacAddressStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DeviceMacAddressStage,
    CargoIdStage,
    _FinalStage {
        private String deviceMacAddress;
        private String cargoId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DevicesLinkToCargoV1Request other) {
            this.deviceMacAddress(other.getDeviceMacAddress());
            this.cargoId(other.getCargoId());
            return this;
        }

        @Override
        @JsonSetter(value="device_mac_address")
        public CargoIdStage deviceMacAddress(@NotNull String deviceMacAddress) {
            this.deviceMacAddress = Objects.requireNonNull(deviceMacAddress, "deviceMacAddress must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="cargo_id")
        public _FinalStage cargoId(@NotNull String cargoId) {
            this.cargoId = Objects.requireNonNull(cargoId, "cargoId must not be null");
            return this;
        }

        @Override
        public DevicesLinkToCargoV1Request build() {
            return new DevicesLinkToCargoV1Request(this.deviceMacAddress, this.cargoId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DevicesLinkToCargoV1Request build();
    }

    public static interface CargoIdStage {
        public _FinalStage cargoId(@NotNull String var1);
    }

    public static interface DeviceMacAddressStage {
        public CargoIdStage deviceMacAddress(@NotNull String var1);

        public Builder from(DevicesLinkToCargoV1Request var1);
    }
}

