/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.tracking.driver.requests;

import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.LocationFeature;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DriverUpdateReq {
    private final OffsetDateTime timestamp;
    private final LocationFeature location;
    private final Map<String, Object> additionalProperties;

    private DriverUpdateReq(OffsetDateTime timestamp, LocationFeature location, Map<String, Object> additionalProperties) {
        this.timestamp = timestamp;
        this.location = location;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="timestamp")
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="location")
    public LocationFeature getLocation() {
        return this.location;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DriverUpdateReq && this.equalTo((DriverUpdateReq)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DriverUpdateReq other) {
        return this.timestamp.equals(other.timestamp) && this.location.equals(other.location);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.location);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TimestampStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TimestampStage,
    LocationStage,
    _FinalStage {
        private OffsetDateTime timestamp;
        private LocationFeature location;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DriverUpdateReq other) {
            this.timestamp(other.getTimestamp());
            this.location(other.getLocation());
            return this;
        }

        @Override
        @JsonSetter(value="timestamp")
        public LocationStage timestamp(@NotNull OffsetDateTime timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="location")
        public _FinalStage location(@NotNull LocationFeature location) {
            this.location = Objects.requireNonNull(location, "location must not be null");
            return this;
        }

        @Override
        public DriverUpdateReq build() {
            return new DriverUpdateReq(this.timestamp, this.location, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DriverUpdateReq build();
    }

    public static interface LocationStage {
        public _FinalStage location(@NotNull LocationFeature var1);
    }

    public static interface TimestampStage {
        public LocationStage timestamp(@NotNull OffsetDateTime var1);

        public Builder from(DriverUpdateReq var1);
    }
}

