/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.tracking.sessions;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.tracking.sessions.AsyncRawSessionsClient;
import com.chrt.api.resources.tracking.sessions.requests.SessionCreateSessionRequest1;
import com.chrt.api.resources.tracking.sessions.requests.SessionUpdateRequest1;
import com.chrt.api.resources.tracking.sessions.requests.SessionsDeleteV1Request;
import com.chrt.api.resources.tracking.sessions.requests.SessionsGetV1Request;
import com.chrt.api.resources.tracking.sessions.requests.SessionsPauseRecordingV1Request;
import com.chrt.api.resources.tracking.sessions.requests.SessionsResumeRecordingV1Request;
import com.chrt.api.resources.tracking.sessions.requests.SessionsStartV1Request;
import com.chrt.api.resources.tracking.sessions.requests.SessionsTerminateV1Request;
import com.chrt.api.types.Session1;
import com.chrt.api.types.SessionDeleteResponse1;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncSessionsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawSessionsClient rawClient;

    public AsyncSessionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawSessionsClient(clientOptions);
    }

    public AsyncRawSessionsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<List<Session1>> listV1() {
        return this.rawClient.listV1().thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<Session1>> listV1(RequestOptions requestOptions) {
        return this.rawClient.listV1(requestOptions).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<Session1> getV1(SessionsGetV1Request request) {
        return this.rawClient.getV1(request).thenApply(response -> (Session1)response.body());
    }

    public CompletableFuture<Session1> getV1(SessionsGetV1Request request, RequestOptions requestOptions) {
        return this.rawClient.getV1(request, requestOptions).thenApply(response -> (Session1)response.body());
    }

    public CompletableFuture<String> createSessionV1(SessionCreateSessionRequest1 request) {
        return this.rawClient.createSessionV1(request).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> createSessionV1(SessionCreateSessionRequest1 request, RequestOptions requestOptions) {
        return this.rawClient.createSessionV1(request, requestOptions).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<Boolean> updateV1(SessionUpdateRequest1 request) {
        return this.rawClient.updateV1(request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateV1(SessionUpdateRequest1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> startV1(SessionsStartV1Request request) {
        return this.rawClient.startV1(request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> startV1(SessionsStartV1Request request, RequestOptions requestOptions) {
        return this.rawClient.startV1(request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> pauseRecordingV1(SessionsPauseRecordingV1Request request) {
        return this.rawClient.pauseRecordingV1(request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> pauseRecordingV1(SessionsPauseRecordingV1Request request, RequestOptions requestOptions) {
        return this.rawClient.pauseRecordingV1(request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> resumeRecordingV1(SessionsResumeRecordingV1Request request) {
        return this.rawClient.resumeRecordingV1(request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> resumeRecordingV1(SessionsResumeRecordingV1Request request, RequestOptions requestOptions) {
        return this.rawClient.resumeRecordingV1(request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> terminateV1(SessionsTerminateV1Request request) {
        return this.rawClient.terminateV1(request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> terminateV1(SessionsTerminateV1Request request, RequestOptions requestOptions) {
        return this.rawClient.terminateV1(request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<SessionDeleteResponse1> deleteV1(SessionsDeleteV1Request request) {
        return this.rawClient.deleteV1(request).thenApply(response -> (SessionDeleteResponse1)response.body());
    }

    public CompletableFuture<SessionDeleteResponse1> deleteV1(SessionsDeleteV1Request request, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(request, requestOptions).thenApply(response -> (SessionDeleteResponse1)response.body());
    }
}

