/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.tracking.sharing;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.tracking.sharing.AsyncRawSharingClient;
import com.chrt.api.resources.tracking.sharing.requests.CargoByDeviceSharingSettingsUpdateReq;
import com.chrt.api.resources.tracking.sharing.requests.CargoByDriverSharingSettingsUpdateReq;
import com.chrt.api.resources.tracking.sharing.requests.TaskGroupByDriverSharingSettingsUpdateReq;
import com.chrt.api.types.CargoByDeviceSharingSettings1;
import com.chrt.api.types.CargoByDriverSharingSettings1;
import com.chrt.api.types.TaskGroupByDriverSharingSettings1;
import com.chrt.api.types.TrackingSharingSettingsRes;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncSharingClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawSharingClient rawClient;

    public AsyncSharingClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawSharingClient(clientOptions);
    }

    public AsyncRawSharingClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<List<TrackingSharingSettingsRes>> getSettingsV1(String orderIdOrShortId) {
        return this.rawClient.getSettingsV1(orderIdOrShortId).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<TrackingSharingSettingsRes>> getSettingsV1(String orderIdOrShortId, RequestOptions requestOptions) {
        return this.rawClient.getSettingsV1(orderIdOrShortId, requestOptions).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<TaskGroupByDriverSharingSettings1> taskGroupByDriverSharingSettingsV1(TaskGroupByDriverSharingSettingsUpdateReq request) {
        return this.rawClient.taskGroupByDriverSharingSettingsV1(request).thenApply(response -> (TaskGroupByDriverSharingSettings1)response.body());
    }

    public CompletableFuture<TaskGroupByDriverSharingSettings1> taskGroupByDriverSharingSettingsV1(TaskGroupByDriverSharingSettingsUpdateReq request, RequestOptions requestOptions) {
        return this.rawClient.taskGroupByDriverSharingSettingsV1(request, requestOptions).thenApply(response -> (TaskGroupByDriverSharingSettings1)response.body());
    }

    public CompletableFuture<CargoByDriverSharingSettings1> cargoByDriverSettingsV1(CargoByDriverSharingSettingsUpdateReq request) {
        return this.rawClient.cargoByDriverSettingsV1(request).thenApply(response -> (CargoByDriverSharingSettings1)response.body());
    }

    public CompletableFuture<CargoByDriverSharingSettings1> cargoByDriverSettingsV1(CargoByDriverSharingSettingsUpdateReq request, RequestOptions requestOptions) {
        return this.rawClient.cargoByDriverSettingsV1(request, requestOptions).thenApply(response -> (CargoByDriverSharingSettings1)response.body());
    }

    public CompletableFuture<CargoByDeviceSharingSettings1> cargoByDeviceSettingsV1(CargoByDeviceSharingSettingsUpdateReq request) {
        return this.rawClient.cargoByDeviceSettingsV1(request).thenApply(response -> (CargoByDeviceSharingSettings1)response.body());
    }

    public CompletableFuture<CargoByDeviceSharingSettings1> cargoByDeviceSettingsV1(CargoByDeviceSharingSettingsUpdateReq request, RequestOptions requestOptions) {
        return this.rawClient.cargoByDeviceSettingsV1(request, requestOptions).thenApply(response -> (CargoByDeviceSharingSettings1)response.body());
    }
}

