/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.tracking.sharing;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.tracking.sharing.RawSharingClient;
import com.chrt.api.resources.tracking.sharing.requests.CargoByDeviceSharingSettingsUpdateReq;
import com.chrt.api.resources.tracking.sharing.requests.CargoByDriverSharingSettingsUpdateReq;
import com.chrt.api.resources.tracking.sharing.requests.TaskGroupByDriverSharingSettingsUpdateReq;
import com.chrt.api.types.CargoByDeviceSharingSettings1;
import com.chrt.api.types.CargoByDriverSharingSettings1;
import com.chrt.api.types.TaskGroupByDriverSharingSettings1;
import com.chrt.api.types.TrackingSharingSettingsRes;
import java.util.List;

public class SharingClient {
    protected final ClientOptions clientOptions;
    private final RawSharingClient rawClient;

    public SharingClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawSharingClient(clientOptions);
    }

    public RawSharingClient withRawResponse() {
        return this.rawClient;
    }

    public List<TrackingSharingSettingsRes> getSettingsV1(String orderIdOrShortId) {
        return this.rawClient.getSettingsV1(orderIdOrShortId).body();
    }

    public List<TrackingSharingSettingsRes> getSettingsV1(String orderIdOrShortId, RequestOptions requestOptions) {
        return this.rawClient.getSettingsV1(orderIdOrShortId, requestOptions).body();
    }

    public TaskGroupByDriverSharingSettings1 taskGroupByDriverSharingSettingsV1(TaskGroupByDriverSharingSettingsUpdateReq request) {
        return this.rawClient.taskGroupByDriverSharingSettingsV1(request).body();
    }

    public TaskGroupByDriverSharingSettings1 taskGroupByDriverSharingSettingsV1(TaskGroupByDriverSharingSettingsUpdateReq request, RequestOptions requestOptions) {
        return this.rawClient.taskGroupByDriverSharingSettingsV1(request, requestOptions).body();
    }

    public CargoByDriverSharingSettings1 cargoByDriverSettingsV1(CargoByDriverSharingSettingsUpdateReq request) {
        return this.rawClient.cargoByDriverSettingsV1(request).body();
    }

    public CargoByDriverSharingSettings1 cargoByDriverSettingsV1(CargoByDriverSharingSettingsUpdateReq request, RequestOptions requestOptions) {
        return this.rawClient.cargoByDriverSettingsV1(request, requestOptions).body();
    }

    public CargoByDeviceSharingSettings1 cargoByDeviceSettingsV1(CargoByDeviceSharingSettingsUpdateReq request) {
        return this.rawClient.cargoByDeviceSettingsV1(request).body();
    }

    public CargoByDeviceSharingSettings1 cargoByDeviceSettingsV1(CargoByDeviceSharingSettingsUpdateReq request, RequestOptions requestOptions) {
        return this.rawClient.cargoByDeviceSettingsV1(request, requestOptions).body();
    }
}

