/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.CargoStatusEnum1;
import com.chrt.api.types.CargoTypeEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Cargo1 {
    private final int schemaVersion;
    private final CargoTypeEnum1 cargoType;
    private final Optional<Integer> quantity;
    private final Optional<Double> weightPounds;
    private final Optional<Double> lengthInches;
    private final Optional<Double> widthInches;
    private final Optional<Double> heightInches;
    private final Optional<Boolean> turnable;
    private final Optional<Boolean> stackable;
    private final Optional<String> description;
    private final String id;
    private final String orderId;
    private final String orderShortId;
    private final String createdByOrgId;
    private final String createdByUserId;
    private final Optional<List<String>> deviceIds;
    private final Optional<CargoStatusEnum1> status;
    private final OffsetDateTime draftStartedAtTimestamp;
    private final Optional<OffsetDateTime> stagedAtTimestamp;
    private final Optional<OffsetDateTime> inTransitAtTimestamp;
    private final Optional<OffsetDateTime> deliveredAtTimestamp;
    private final Optional<OffsetDateTime> skippedAtTimestamp;
    private final Optional<OffsetDateTime> exceptionAtTimestamp;
    private final Map<String, Object> additionalProperties;

    private Cargo1(int schemaVersion, CargoTypeEnum1 cargoType, Optional<Integer> quantity, Optional<Double> weightPounds, Optional<Double> lengthInches, Optional<Double> widthInches, Optional<Double> heightInches, Optional<Boolean> turnable, Optional<Boolean> stackable, Optional<String> description, String id, String orderId, String orderShortId, String createdByOrgId, String createdByUserId, Optional<List<String>> deviceIds, Optional<CargoStatusEnum1> status, OffsetDateTime draftStartedAtTimestamp, Optional<OffsetDateTime> stagedAtTimestamp, Optional<OffsetDateTime> inTransitAtTimestamp, Optional<OffsetDateTime> deliveredAtTimestamp, Optional<OffsetDateTime> skippedAtTimestamp, Optional<OffsetDateTime> exceptionAtTimestamp, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.cargoType = cargoType;
        this.quantity = quantity;
        this.weightPounds = weightPounds;
        this.lengthInches = lengthInches;
        this.widthInches = widthInches;
        this.heightInches = heightInches;
        this.turnable = turnable;
        this.stackable = stackable;
        this.description = description;
        this.id = id;
        this.orderId = orderId;
        this.orderShortId = orderShortId;
        this.createdByOrgId = createdByOrgId;
        this.createdByUserId = createdByUserId;
        this.deviceIds = deviceIds;
        this.status = status;
        this.draftStartedAtTimestamp = draftStartedAtTimestamp;
        this.stagedAtTimestamp = stagedAtTimestamp;
        this.inTransitAtTimestamp = inTransitAtTimestamp;
        this.deliveredAtTimestamp = deliveredAtTimestamp;
        this.skippedAtTimestamp = skippedAtTimestamp;
        this.exceptionAtTimestamp = exceptionAtTimestamp;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="cargo_type")
    public CargoTypeEnum1 getCargoType() {
        return this.cargoType;
    }

    @JsonIgnore
    public Optional<Integer> getQuantity() {
        if (this.quantity == null) {
            return Optional.empty();
        }
        return this.quantity;
    }

    @JsonIgnore
    public Optional<Double> getWeightPounds() {
        if (this.weightPounds == null) {
            return Optional.empty();
        }
        return this.weightPounds;
    }

    @JsonIgnore
    public Optional<Double> getLengthInches() {
        if (this.lengthInches == null) {
            return Optional.empty();
        }
        return this.lengthInches;
    }

    @JsonIgnore
    public Optional<Double> getWidthInches() {
        if (this.widthInches == null) {
            return Optional.empty();
        }
        return this.widthInches;
    }

    @JsonIgnore
    public Optional<Double> getHeightInches() {
        if (this.heightInches == null) {
            return Optional.empty();
        }
        return this.heightInches;
    }

    @JsonIgnore
    public Optional<Boolean> getTurnable() {
        if (this.turnable == null) {
            return Optional.empty();
        }
        return this.turnable;
    }

    @JsonIgnore
    public Optional<Boolean> getStackable() {
        if (this.stackable == null) {
            return Optional.empty();
        }
        return this.stackable;
    }

    @JsonIgnore
    public Optional<String> getDescription() {
        if (this.description == null) {
            return Optional.empty();
        }
        return this.description;
    }

    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="order_id")
    public String getOrderId() {
        return this.orderId;
    }

    @JsonProperty(value="order_short_id")
    public String getOrderShortId() {
        return this.orderShortId;
    }

    @JsonProperty(value="created_by_org_id")
    public String getCreatedByOrgId() {
        return this.createdByOrgId;
    }

    @JsonProperty(value="created_by_user_id")
    public String getCreatedByUserId() {
        return this.createdByUserId;
    }

    @JsonProperty(value="device_ids")
    public Optional<List<String>> getDeviceIds() {
        return this.deviceIds;
    }

    @JsonProperty(value="status")
    public Optional<CargoStatusEnum1> getStatus() {
        return this.status;
    }

    @JsonProperty(value="draft_started_at_timestamp")
    public OffsetDateTime getDraftStartedAtTimestamp() {
        return this.draftStartedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getStagedAtTimestamp() {
        if (this.stagedAtTimestamp == null) {
            return Optional.empty();
        }
        return this.stagedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getInTransitAtTimestamp() {
        if (this.inTransitAtTimestamp == null) {
            return Optional.empty();
        }
        return this.inTransitAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getDeliveredAtTimestamp() {
        if (this.deliveredAtTimestamp == null) {
            return Optional.empty();
        }
        return this.deliveredAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getSkippedAtTimestamp() {
        if (this.skippedAtTimestamp == null) {
            return Optional.empty();
        }
        return this.skippedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getExceptionAtTimestamp() {
        if (this.exceptionAtTimestamp == null) {
            return Optional.empty();
        }
        return this.exceptionAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="quantity")
    private Optional<Integer> _getQuantity() {
        return this.quantity;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="weight_pounds")
    private Optional<Double> _getWeightPounds() {
        return this.weightPounds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="length_inches")
    private Optional<Double> _getLengthInches() {
        return this.lengthInches;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="width_inches")
    private Optional<Double> _getWidthInches() {
        return this.widthInches;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="height_inches")
    private Optional<Double> _getHeightInches() {
        return this.heightInches;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="turnable")
    private Optional<Boolean> _getTurnable() {
        return this.turnable;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="stackable")
    private Optional<Boolean> _getStackable() {
        return this.stackable;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="description")
    private Optional<String> _getDescription() {
        return this.description;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="staged_at_timestamp")
    private Optional<OffsetDateTime> _getStagedAtTimestamp() {
        return this.stagedAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="in_transit_at_timestamp")
    private Optional<OffsetDateTime> _getInTransitAtTimestamp() {
        return this.inTransitAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="delivered_at_timestamp")
    private Optional<OffsetDateTime> _getDeliveredAtTimestamp() {
        return this.deliveredAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="skipped_at_timestamp")
    private Optional<OffsetDateTime> _getSkippedAtTimestamp() {
        return this.skippedAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="exception_at_timestamp")
    private Optional<OffsetDateTime> _getExceptionAtTimestamp() {
        return this.exceptionAtTimestamp;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Cargo1 && this.equalTo((Cargo1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Cargo1 other) {
        return this.schemaVersion == other.schemaVersion && this.cargoType.equals(other.cargoType) && this.quantity.equals(other.quantity) && this.weightPounds.equals(other.weightPounds) && this.lengthInches.equals(other.lengthInches) && this.widthInches.equals(other.widthInches) && this.heightInches.equals(other.heightInches) && this.turnable.equals(other.turnable) && this.stackable.equals(other.stackable) && this.description.equals(other.description) && this.id.equals(other.id) && this.orderId.equals(other.orderId) && this.orderShortId.equals(other.orderShortId) && this.createdByOrgId.equals(other.createdByOrgId) && this.createdByUserId.equals(other.createdByUserId) && this.deviceIds.equals(other.deviceIds) && this.status.equals(other.status) && this.draftStartedAtTimestamp.equals(other.draftStartedAtTimestamp) && this.stagedAtTimestamp.equals(other.stagedAtTimestamp) && this.inTransitAtTimestamp.equals(other.inTransitAtTimestamp) && this.deliveredAtTimestamp.equals(other.deliveredAtTimestamp) && this.skippedAtTimestamp.equals(other.skippedAtTimestamp) && this.exceptionAtTimestamp.equals(other.exceptionAtTimestamp);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.cargoType, this.quantity, this.weightPounds, this.lengthInches, this.widthInches, this.heightInches, this.turnable, this.stackable, this.description, this.id, this.orderId, this.orderShortId, this.createdByOrgId, this.createdByUserId, this.deviceIds, this.status, this.draftStartedAtTimestamp, this.stagedAtTimestamp, this.inTransitAtTimestamp, this.deliveredAtTimestamp, this.skippedAtTimestamp, this.exceptionAtTimestamp);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    CargoTypeStage,
    IdStage,
    OrderIdStage,
    OrderShortIdStage,
    CreatedByOrgIdStage,
    CreatedByUserIdStage,
    DraftStartedAtTimestampStage,
    _FinalStage {
        private int schemaVersion;
        private CargoTypeEnum1 cargoType;
        private String id;
        private String orderId;
        private String orderShortId;
        private String createdByOrgId;
        private String createdByUserId;
        private OffsetDateTime draftStartedAtTimestamp;
        private Optional<OffsetDateTime> exceptionAtTimestamp = Optional.empty();
        private Optional<OffsetDateTime> skippedAtTimestamp = Optional.empty();
        private Optional<OffsetDateTime> deliveredAtTimestamp = Optional.empty();
        private Optional<OffsetDateTime> inTransitAtTimestamp = Optional.empty();
        private Optional<OffsetDateTime> stagedAtTimestamp = Optional.empty();
        private Optional<CargoStatusEnum1> status = Optional.empty();
        private Optional<List<String>> deviceIds = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<Boolean> stackable = Optional.empty();
        private Optional<Boolean> turnable = Optional.empty();
        private Optional<Double> heightInches = Optional.empty();
        private Optional<Double> widthInches = Optional.empty();
        private Optional<Double> lengthInches = Optional.empty();
        private Optional<Double> weightPounds = Optional.empty();
        private Optional<Integer> quantity = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Cargo1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.cargoType(other.getCargoType());
            this.quantity(other.getQuantity());
            this.weightPounds(other.getWeightPounds());
            this.lengthInches(other.getLengthInches());
            this.widthInches(other.getWidthInches());
            this.heightInches(other.getHeightInches());
            this.turnable(other.getTurnable());
            this.stackable(other.getStackable());
            this.description(other.getDescription());
            this.id(other.getId());
            this.orderId(other.getOrderId());
            this.orderShortId(other.getOrderShortId());
            this.createdByOrgId(other.getCreatedByOrgId());
            this.createdByUserId(other.getCreatedByUserId());
            this.deviceIds(other.getDeviceIds());
            this.status(other.getStatus());
            this.draftStartedAtTimestamp(other.getDraftStartedAtTimestamp());
            this.stagedAtTimestamp(other.getStagedAtTimestamp());
            this.inTransitAtTimestamp(other.getInTransitAtTimestamp());
            this.deliveredAtTimestamp(other.getDeliveredAtTimestamp());
            this.skippedAtTimestamp(other.getSkippedAtTimestamp());
            this.exceptionAtTimestamp(other.getExceptionAtTimestamp());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public CargoTypeStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="cargo_type")
        public IdStage cargoType(@NotNull CargoTypeEnum1 cargoType) {
            this.cargoType = Objects.requireNonNull(cargoType, "cargoType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="_id")
        public OrderIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="order_id")
        public OrderShortIdStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="order_short_id")
        public CreatedByOrgIdStage orderShortId(@NotNull String orderShortId) {
            this.orderShortId = Objects.requireNonNull(orderShortId, "orderShortId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_by_org_id")
        public CreatedByUserIdStage createdByOrgId(@NotNull String createdByOrgId) {
            this.createdByOrgId = Objects.requireNonNull(createdByOrgId, "createdByOrgId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_by_user_id")
        public DraftStartedAtTimestampStage createdByUserId(@NotNull String createdByUserId) {
            this.createdByUserId = Objects.requireNonNull(createdByUserId, "createdByUserId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="draft_started_at_timestamp")
        public _FinalStage draftStartedAtTimestamp(@NotNull OffsetDateTime draftStartedAtTimestamp) {
            this.draftStartedAtTimestamp = Objects.requireNonNull(draftStartedAtTimestamp, "draftStartedAtTimestamp must not be null");
            return this;
        }

        @Override
        public _FinalStage exceptionAtTimestamp(Nullable<OffsetDateTime> exceptionAtTimestamp) {
            this.exceptionAtTimestamp = exceptionAtTimestamp.isNull() ? null : (exceptionAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(exceptionAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage exceptionAtTimestamp(OffsetDateTime exceptionAtTimestamp) {
            this.exceptionAtTimestamp = Optional.ofNullable(exceptionAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="exception_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage exceptionAtTimestamp(Optional<OffsetDateTime> exceptionAtTimestamp) {
            this.exceptionAtTimestamp = exceptionAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage skippedAtTimestamp(Nullable<OffsetDateTime> skippedAtTimestamp) {
            this.skippedAtTimestamp = skippedAtTimestamp.isNull() ? null : (skippedAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(skippedAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage skippedAtTimestamp(OffsetDateTime skippedAtTimestamp) {
            this.skippedAtTimestamp = Optional.ofNullable(skippedAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="skipped_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage skippedAtTimestamp(Optional<OffsetDateTime> skippedAtTimestamp) {
            this.skippedAtTimestamp = skippedAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage deliveredAtTimestamp(Nullable<OffsetDateTime> deliveredAtTimestamp) {
            this.deliveredAtTimestamp = deliveredAtTimestamp.isNull() ? null : (deliveredAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(deliveredAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage deliveredAtTimestamp(OffsetDateTime deliveredAtTimestamp) {
            this.deliveredAtTimestamp = Optional.ofNullable(deliveredAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="delivered_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage deliveredAtTimestamp(Optional<OffsetDateTime> deliveredAtTimestamp) {
            this.deliveredAtTimestamp = deliveredAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage inTransitAtTimestamp(Nullable<OffsetDateTime> inTransitAtTimestamp) {
            this.inTransitAtTimestamp = inTransitAtTimestamp.isNull() ? null : (inTransitAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(inTransitAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage inTransitAtTimestamp(OffsetDateTime inTransitAtTimestamp) {
            this.inTransitAtTimestamp = Optional.ofNullable(inTransitAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="in_transit_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage inTransitAtTimestamp(Optional<OffsetDateTime> inTransitAtTimestamp) {
            this.inTransitAtTimestamp = inTransitAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage stagedAtTimestamp(Nullable<OffsetDateTime> stagedAtTimestamp) {
            this.stagedAtTimestamp = stagedAtTimestamp.isNull() ? null : (stagedAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(stagedAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage stagedAtTimestamp(OffsetDateTime stagedAtTimestamp) {
            this.stagedAtTimestamp = Optional.ofNullable(stagedAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="staged_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage stagedAtTimestamp(Optional<OffsetDateTime> stagedAtTimestamp) {
            this.stagedAtTimestamp = stagedAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage status(CargoStatusEnum1 status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<CargoStatusEnum1> status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage deviceIds(List<String> deviceIds) {
            this.deviceIds = Optional.ofNullable(deviceIds);
            return this;
        }

        @Override
        @JsonSetter(value="device_ids", nulls=Nulls.SKIP)
        public _FinalStage deviceIds(Optional<List<String>> deviceIds) {
            this.deviceIds = deviceIds;
            return this;
        }

        @Override
        public _FinalStage description(Nullable<String> description) {
            this.description = description.isNull() ? null : (description.isEmpty() ? Optional.empty() : Optional.of(description.get()));
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public _FinalStage stackable(Nullable<Boolean> stackable) {
            this.stackable = stackable.isNull() ? null : (stackable.isEmpty() ? Optional.empty() : Optional.of(stackable.get()));
            return this;
        }

        @Override
        public _FinalStage stackable(Boolean stackable) {
            this.stackable = Optional.ofNullable(stackable);
            return this;
        }

        @Override
        @JsonSetter(value="stackable", nulls=Nulls.SKIP)
        public _FinalStage stackable(Optional<Boolean> stackable) {
            this.stackable = stackable;
            return this;
        }

        @Override
        public _FinalStage turnable(Nullable<Boolean> turnable) {
            this.turnable = turnable.isNull() ? null : (turnable.isEmpty() ? Optional.empty() : Optional.of(turnable.get()));
            return this;
        }

        @Override
        public _FinalStage turnable(Boolean turnable) {
            this.turnable = Optional.ofNullable(turnable);
            return this;
        }

        @Override
        @JsonSetter(value="turnable", nulls=Nulls.SKIP)
        public _FinalStage turnable(Optional<Boolean> turnable) {
            this.turnable = turnable;
            return this;
        }

        @Override
        public _FinalStage heightInches(Nullable<Double> heightInches) {
            this.heightInches = heightInches.isNull() ? null : (heightInches.isEmpty() ? Optional.empty() : Optional.of(heightInches.get()));
            return this;
        }

        @Override
        public _FinalStage heightInches(Double heightInches) {
            this.heightInches = Optional.ofNullable(heightInches);
            return this;
        }

        @Override
        @JsonSetter(value="height_inches", nulls=Nulls.SKIP)
        public _FinalStage heightInches(Optional<Double> heightInches) {
            this.heightInches = heightInches;
            return this;
        }

        @Override
        public _FinalStage widthInches(Nullable<Double> widthInches) {
            this.widthInches = widthInches.isNull() ? null : (widthInches.isEmpty() ? Optional.empty() : Optional.of(widthInches.get()));
            return this;
        }

        @Override
        public _FinalStage widthInches(Double widthInches) {
            this.widthInches = Optional.ofNullable(widthInches);
            return this;
        }

        @Override
        @JsonSetter(value="width_inches", nulls=Nulls.SKIP)
        public _FinalStage widthInches(Optional<Double> widthInches) {
            this.widthInches = widthInches;
            return this;
        }

        @Override
        public _FinalStage lengthInches(Nullable<Double> lengthInches) {
            this.lengthInches = lengthInches.isNull() ? null : (lengthInches.isEmpty() ? Optional.empty() : Optional.of(lengthInches.get()));
            return this;
        }

        @Override
        public _FinalStage lengthInches(Double lengthInches) {
            this.lengthInches = Optional.ofNullable(lengthInches);
            return this;
        }

        @Override
        @JsonSetter(value="length_inches", nulls=Nulls.SKIP)
        public _FinalStage lengthInches(Optional<Double> lengthInches) {
            this.lengthInches = lengthInches;
            return this;
        }

        @Override
        public _FinalStage weightPounds(Nullable<Double> weightPounds) {
            this.weightPounds = weightPounds.isNull() ? null : (weightPounds.isEmpty() ? Optional.empty() : Optional.of(weightPounds.get()));
            return this;
        }

        @Override
        public _FinalStage weightPounds(Double weightPounds) {
            this.weightPounds = Optional.ofNullable(weightPounds);
            return this;
        }

        @Override
        @JsonSetter(value="weight_pounds", nulls=Nulls.SKIP)
        public _FinalStage weightPounds(Optional<Double> weightPounds) {
            this.weightPounds = weightPounds;
            return this;
        }

        @Override
        public _FinalStage quantity(Nullable<Integer> quantity) {
            this.quantity = quantity.isNull() ? null : (quantity.isEmpty() ? Optional.empty() : Optional.of(quantity.get()));
            return this;
        }

        @Override
        public _FinalStage quantity(Integer quantity) {
            this.quantity = Optional.ofNullable(quantity);
            return this;
        }

        @Override
        @JsonSetter(value="quantity", nulls=Nulls.SKIP)
        public _FinalStage quantity(Optional<Integer> quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        public Cargo1 build() {
            return new Cargo1(this.schemaVersion, this.cargoType, this.quantity, this.weightPounds, this.lengthInches, this.widthInches, this.heightInches, this.turnable, this.stackable, this.description, this.id, this.orderId, this.orderShortId, this.createdByOrgId, this.createdByUserId, this.deviceIds, this.status, this.draftStartedAtTimestamp, this.stagedAtTimestamp, this.inTransitAtTimestamp, this.deliveredAtTimestamp, this.skippedAtTimestamp, this.exceptionAtTimestamp, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Cargo1 build();

        public _FinalStage quantity(Optional<Integer> var1);

        public _FinalStage quantity(Integer var1);

        public _FinalStage quantity(Nullable<Integer> var1);

        public _FinalStage weightPounds(Optional<Double> var1);

        public _FinalStage weightPounds(Double var1);

        public _FinalStage weightPounds(Nullable<Double> var1);

        public _FinalStage lengthInches(Optional<Double> var1);

        public _FinalStage lengthInches(Double var1);

        public _FinalStage lengthInches(Nullable<Double> var1);

        public _FinalStage widthInches(Optional<Double> var1);

        public _FinalStage widthInches(Double var1);

        public _FinalStage widthInches(Nullable<Double> var1);

        public _FinalStage heightInches(Optional<Double> var1);

        public _FinalStage heightInches(Double var1);

        public _FinalStage heightInches(Nullable<Double> var1);

        public _FinalStage turnable(Optional<Boolean> var1);

        public _FinalStage turnable(Boolean var1);

        public _FinalStage turnable(Nullable<Boolean> var1);

        public _FinalStage stackable(Optional<Boolean> var1);

        public _FinalStage stackable(Boolean var1);

        public _FinalStage stackable(Nullable<Boolean> var1);

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);

        public _FinalStage description(Nullable<String> var1);

        public _FinalStage deviceIds(Optional<List<String>> var1);

        public _FinalStage deviceIds(List<String> var1);

        public _FinalStage status(Optional<CargoStatusEnum1> var1);

        public _FinalStage status(CargoStatusEnum1 var1);

        public _FinalStage stagedAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage stagedAtTimestamp(OffsetDateTime var1);

        public _FinalStage stagedAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage inTransitAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage inTransitAtTimestamp(OffsetDateTime var1);

        public _FinalStage inTransitAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage deliveredAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage deliveredAtTimestamp(OffsetDateTime var1);

        public _FinalStage deliveredAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage skippedAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage skippedAtTimestamp(OffsetDateTime var1);

        public _FinalStage skippedAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage exceptionAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage exceptionAtTimestamp(OffsetDateTime var1);

        public _FinalStage exceptionAtTimestamp(Nullable<OffsetDateTime> var1);
    }

    public static interface DraftStartedAtTimestampStage {
        public _FinalStage draftStartedAtTimestamp(@NotNull OffsetDateTime var1);
    }

    public static interface CreatedByUserIdStage {
        public DraftStartedAtTimestampStage createdByUserId(@NotNull String var1);
    }

    public static interface CreatedByOrgIdStage {
        public CreatedByUserIdStage createdByOrgId(@NotNull String var1);
    }

    public static interface OrderShortIdStage {
        public CreatedByOrgIdStage orderShortId(@NotNull String var1);
    }

    public static interface OrderIdStage {
        public OrderShortIdStage orderId(@NotNull String var1);
    }

    public static interface IdStage {
        public OrderIdStage id(@NotNull String var1);
    }

    public static interface CargoTypeStage {
        public IdStage cargoType(@NotNull CargoTypeEnum1 var1);
    }

    public static interface SchemaVersionStage {
        public CargoTypeStage schemaVersion(int var1);

        public Builder from(Cargo1 var1);
    }
}

