/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.OrgRoleEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ClerkOrgData {
    private final Optional<String> id;
    private final Optional<OrgRoleEnum> rol;
    private final Optional<String> slg;
    private final Map<String, Object> additionalProperties;

    private ClerkOrgData(Optional<String> id, Optional<OrgRoleEnum> rol, Optional<String> slg, Map<String, Object> additionalProperties) {
        this.id = id;
        this.rol = rol;
        this.slg = slg;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getId() {
        if (this.id == null) {
            return Optional.empty();
        }
        return this.id;
    }

    @JsonIgnore
    public Optional<OrgRoleEnum> getRol() {
        if (this.rol == null) {
            return Optional.empty();
        }
        return this.rol;
    }

    @JsonIgnore
    public Optional<String> getSlg() {
        if (this.slg == null) {
            return Optional.empty();
        }
        return this.slg;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="id")
    private Optional<String> _getId() {
        return this.id;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="rol")
    private Optional<OrgRoleEnum> _getRol() {
        return this.rol;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="slg")
    private Optional<String> _getSlg() {
        return this.slg;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ClerkOrgData && this.equalTo((ClerkOrgData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ClerkOrgData other) {
        return this.id.equals(other.id) && this.rol.equals(other.rol) && this.slg.equals(other.slg);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.rol, this.slg);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<OrgRoleEnum> rol = Optional.empty();
        private Optional<String> slg = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ClerkOrgData other) {
            this.id(other.getId());
            this.rol(other.getRol());
            this.slg(other.getSlg());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        public Builder id(Nullable<String> id) {
            this.id = id.isNull() ? null : (id.isEmpty() ? Optional.empty() : Optional.of(id.get()));
            return this;
        }

        @JsonSetter(value="rol", nulls=Nulls.SKIP)
        public Builder rol(Optional<OrgRoleEnum> rol) {
            this.rol = rol;
            return this;
        }

        public Builder rol(OrgRoleEnum rol) {
            this.rol = Optional.ofNullable(rol);
            return this;
        }

        public Builder rol(Nullable<OrgRoleEnum> rol) {
            this.rol = rol.isNull() ? null : (rol.isEmpty() ? Optional.empty() : Optional.of(rol.get()));
            return this;
        }

        @JsonSetter(value="slg", nulls=Nulls.SKIP)
        public Builder slg(Optional<String> slg) {
            this.slg = slg;
            return this;
        }

        public Builder slg(String slg) {
            this.slg = Optional.ofNullable(slg);
            return this;
        }

        public Builder slg(Nullable<String> slg) {
            this.slg = slg.isNull() ? null : (slg.isEmpty() ? Optional.empty() : Optional.of(slg.get()));
            return this;
        }

        public ClerkOrgData build() {
            return new ClerkOrgData(this.id, this.rol, this.slg, this.additionalProperties);
        }
    }
}

