/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CourierPayDriverLineItemGroupCreateReq {
    private final String courierPayDriverRateSheetId;
    private final String taskGroupId;
    private final Optional<Boolean> dangerousGoods;
    private final Optional<Boolean> holiday;
    private final Optional<Boolean> weekend;
    private final Optional<Boolean> afterHours;
    private final Map<String, Object> additionalProperties;

    private CourierPayDriverLineItemGroupCreateReq(String courierPayDriverRateSheetId, String taskGroupId, Optional<Boolean> dangerousGoods, Optional<Boolean> holiday, Optional<Boolean> weekend, Optional<Boolean> afterHours, Map<String, Object> additionalProperties) {
        this.courierPayDriverRateSheetId = courierPayDriverRateSheetId;
        this.taskGroupId = taskGroupId;
        this.dangerousGoods = dangerousGoods;
        this.holiday = holiday;
        this.weekend = weekend;
        this.afterHours = afterHours;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="courier_pay_driver_rate_sheet_id")
    public String getCourierPayDriverRateSheetId() {
        return this.courierPayDriverRateSheetId;
    }

    @JsonProperty(value="task_group_id")
    public String getTaskGroupId() {
        return this.taskGroupId;
    }

    @JsonProperty(value="dangerous_goods")
    public Optional<Boolean> getDangerousGoods() {
        return this.dangerousGoods;
    }

    @JsonProperty(value="holiday")
    public Optional<Boolean> getHoliday() {
        return this.holiday;
    }

    @JsonProperty(value="weekend")
    public Optional<Boolean> getWeekend() {
        return this.weekend;
    }

    @JsonProperty(value="after_hours")
    public Optional<Boolean> getAfterHours() {
        return this.afterHours;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CourierPayDriverLineItemGroupCreateReq && this.equalTo((CourierPayDriverLineItemGroupCreateReq)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CourierPayDriverLineItemGroupCreateReq other) {
        return this.courierPayDriverRateSheetId.equals(other.courierPayDriverRateSheetId) && this.taskGroupId.equals(other.taskGroupId) && this.dangerousGoods.equals(other.dangerousGoods) && this.holiday.equals(other.holiday) && this.weekend.equals(other.weekend) && this.afterHours.equals(other.afterHours);
    }

    public int hashCode() {
        return Objects.hash(this.courierPayDriverRateSheetId, this.taskGroupId, this.dangerousGoods, this.holiday, this.weekend, this.afterHours);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CourierPayDriverRateSheetIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CourierPayDriverRateSheetIdStage,
    TaskGroupIdStage,
    _FinalStage {
        private String courierPayDriverRateSheetId;
        private String taskGroupId;
        private Optional<Boolean> afterHours = Optional.empty();
        private Optional<Boolean> weekend = Optional.empty();
        private Optional<Boolean> holiday = Optional.empty();
        private Optional<Boolean> dangerousGoods = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CourierPayDriverLineItemGroupCreateReq other) {
            this.courierPayDriverRateSheetId(other.getCourierPayDriverRateSheetId());
            this.taskGroupId(other.getTaskGroupId());
            this.dangerousGoods(other.getDangerousGoods());
            this.holiday(other.getHoliday());
            this.weekend(other.getWeekend());
            this.afterHours(other.getAfterHours());
            return this;
        }

        @Override
        @JsonSetter(value="courier_pay_driver_rate_sheet_id")
        public TaskGroupIdStage courierPayDriverRateSheetId(@NotNull String courierPayDriverRateSheetId) {
            this.courierPayDriverRateSheetId = Objects.requireNonNull(courierPayDriverRateSheetId, "courierPayDriverRateSheetId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="task_group_id")
        public _FinalStage taskGroupId(@NotNull String taskGroupId) {
            this.taskGroupId = Objects.requireNonNull(taskGroupId, "taskGroupId must not be null");
            return this;
        }

        @Override
        public _FinalStage afterHours(Boolean afterHours) {
            this.afterHours = Optional.ofNullable(afterHours);
            return this;
        }

        @Override
        @JsonSetter(value="after_hours", nulls=Nulls.SKIP)
        public _FinalStage afterHours(Optional<Boolean> afterHours) {
            this.afterHours = afterHours;
            return this;
        }

        @Override
        public _FinalStage weekend(Boolean weekend) {
            this.weekend = Optional.ofNullable(weekend);
            return this;
        }

        @Override
        @JsonSetter(value="weekend", nulls=Nulls.SKIP)
        public _FinalStage weekend(Optional<Boolean> weekend) {
            this.weekend = weekend;
            return this;
        }

        @Override
        public _FinalStage holiday(Boolean holiday) {
            this.holiday = Optional.ofNullable(holiday);
            return this;
        }

        @Override
        @JsonSetter(value="holiday", nulls=Nulls.SKIP)
        public _FinalStage holiday(Optional<Boolean> holiday) {
            this.holiday = holiday;
            return this;
        }

        @Override
        public _FinalStage dangerousGoods(Boolean dangerousGoods) {
            this.dangerousGoods = Optional.ofNullable(dangerousGoods);
            return this;
        }

        @Override
        @JsonSetter(value="dangerous_goods", nulls=Nulls.SKIP)
        public _FinalStage dangerousGoods(Optional<Boolean> dangerousGoods) {
            this.dangerousGoods = dangerousGoods;
            return this;
        }

        @Override
        public CourierPayDriverLineItemGroupCreateReq build() {
            return new CourierPayDriverLineItemGroupCreateReq(this.courierPayDriverRateSheetId, this.taskGroupId, this.dangerousGoods, this.holiday, this.weekend, this.afterHours, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CourierPayDriverLineItemGroupCreateReq build();

        public _FinalStage dangerousGoods(Optional<Boolean> var1);

        public _FinalStage dangerousGoods(Boolean var1);

        public _FinalStage holiday(Optional<Boolean> var1);

        public _FinalStage holiday(Boolean var1);

        public _FinalStage weekend(Optional<Boolean> var1);

        public _FinalStage weekend(Boolean var1);

        public _FinalStage afterHours(Optional<Boolean> var1);

        public _FinalStage afterHours(Boolean var1);
    }

    public static interface TaskGroupIdStage {
        public _FinalStage taskGroupId(@NotNull String var1);
    }

    public static interface CourierPayDriverRateSheetIdStage {
        public TaskGroupIdStage courierPayDriverRateSheetId(@NotNull String var1);

        public Builder from(CourierPayDriverLineItemGroupCreateReq var1);
    }
}

