/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.LineItem1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CourierPayDriverLineItemGroupServerCreate1 {
    private final int schemaVersion;
    private final String driverId;
    private final String taskGroupId;
    private final String courierOrgId;
    private final Optional<Boolean> orderCancelled;
    private final List<LineItem1> lineItems;
    private final String rateSheetId;
    private final Map<String, Object> additionalProperties;

    private CourierPayDriverLineItemGroupServerCreate1(int schemaVersion, String driverId, String taskGroupId, String courierOrgId, Optional<Boolean> orderCancelled, List<LineItem1> lineItems, String rateSheetId, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.driverId = driverId;
        this.taskGroupId = taskGroupId;
        this.courierOrgId = courierOrgId;
        this.orderCancelled = orderCancelled;
        this.lineItems = lineItems;
        this.rateSheetId = rateSheetId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="driver_id")
    public String getDriverId() {
        return this.driverId;
    }

    @JsonProperty(value="task_group_id")
    public String getTaskGroupId() {
        return this.taskGroupId;
    }

    @JsonProperty(value="courier_org_id")
    public String getCourierOrgId() {
        return this.courierOrgId;
    }

    @JsonProperty(value="order_cancelled")
    public Optional<Boolean> getOrderCancelled() {
        return this.orderCancelled;
    }

    @JsonProperty(value="line_items")
    public List<LineItem1> getLineItems() {
        return this.lineItems;
    }

    @JsonProperty(value="rate_sheet_id")
    public String getRateSheetId() {
        return this.rateSheetId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CourierPayDriverLineItemGroupServerCreate1 && this.equalTo((CourierPayDriverLineItemGroupServerCreate1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CourierPayDriverLineItemGroupServerCreate1 other) {
        return this.schemaVersion == other.schemaVersion && this.driverId.equals(other.driverId) && this.taskGroupId.equals(other.taskGroupId) && this.courierOrgId.equals(other.courierOrgId) && this.orderCancelled.equals(other.orderCancelled) && this.lineItems.equals(other.lineItems) && this.rateSheetId.equals(other.rateSheetId);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.driverId, this.taskGroupId, this.courierOrgId, this.orderCancelled, this.lineItems, this.rateSheetId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    DriverIdStage,
    TaskGroupIdStage,
    CourierOrgIdStage,
    RateSheetIdStage,
    _FinalStage {
        private int schemaVersion;
        private String driverId;
        private String taskGroupId;
        private String courierOrgId;
        private String rateSheetId;
        private List<LineItem1> lineItems = new ArrayList<LineItem1>();
        private Optional<Boolean> orderCancelled = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CourierPayDriverLineItemGroupServerCreate1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.driverId(other.getDriverId());
            this.taskGroupId(other.getTaskGroupId());
            this.courierOrgId(other.getCourierOrgId());
            this.orderCancelled(other.getOrderCancelled());
            this.lineItems(other.getLineItems());
            this.rateSheetId(other.getRateSheetId());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public DriverIdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="driver_id")
        public TaskGroupIdStage driverId(@NotNull String driverId) {
            this.driverId = Objects.requireNonNull(driverId, "driverId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="task_group_id")
        public CourierOrgIdStage taskGroupId(@NotNull String taskGroupId) {
            this.taskGroupId = Objects.requireNonNull(taskGroupId, "taskGroupId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="courier_org_id")
        public RateSheetIdStage courierOrgId(@NotNull String courierOrgId) {
            this.courierOrgId = Objects.requireNonNull(courierOrgId, "courierOrgId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="rate_sheet_id")
        public _FinalStage rateSheetId(@NotNull String rateSheetId) {
            this.rateSheetId = Objects.requireNonNull(rateSheetId, "rateSheetId must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllLineItems(List<LineItem1> lineItems) {
            if (lineItems != null) {
                this.lineItems.addAll(lineItems);
            }
            return this;
        }

        @Override
        public _FinalStage addLineItems(LineItem1 lineItems) {
            this.lineItems.add(lineItems);
            return this;
        }

        @Override
        @JsonSetter(value="line_items", nulls=Nulls.SKIP)
        public _FinalStage lineItems(List<LineItem1> lineItems) {
            this.lineItems.clear();
            if (lineItems != null) {
                this.lineItems.addAll(lineItems);
            }
            return this;
        }

        @Override
        public _FinalStage orderCancelled(Boolean orderCancelled) {
            this.orderCancelled = Optional.ofNullable(orderCancelled);
            return this;
        }

        @Override
        @JsonSetter(value="order_cancelled", nulls=Nulls.SKIP)
        public _FinalStage orderCancelled(Optional<Boolean> orderCancelled) {
            this.orderCancelled = orderCancelled;
            return this;
        }

        @Override
        public CourierPayDriverLineItemGroupServerCreate1 build() {
            return new CourierPayDriverLineItemGroupServerCreate1(this.schemaVersion, this.driverId, this.taskGroupId, this.courierOrgId, this.orderCancelled, this.lineItems, this.rateSheetId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CourierPayDriverLineItemGroupServerCreate1 build();

        public _FinalStage orderCancelled(Optional<Boolean> var1);

        public _FinalStage orderCancelled(Boolean var1);

        public _FinalStage lineItems(List<LineItem1> var1);

        public _FinalStage addLineItems(LineItem1 var1);

        public _FinalStage addAllLineItems(List<LineItem1> var1);
    }

    public static interface RateSheetIdStage {
        public _FinalStage rateSheetId(@NotNull String var1);
    }

    public static interface CourierOrgIdStage {
        public RateSheetIdStage courierOrgId(@NotNull String var1);
    }

    public static interface TaskGroupIdStage {
        public CourierOrgIdStage taskGroupId(@NotNull String var1);
    }

    public static interface DriverIdStage {
        public TaskGroupIdStage driverId(@NotNull String var1);
    }

    public static interface SchemaVersionStage {
        public DriverIdStage schemaVersion(int var1);

        public Builder from(CourierPayDriverLineItemGroupServerCreate1 var1);
    }
}

