/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.StatementStatusEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CourierPayDriverStatement1 {
    private final int schemaVersion;
    private final List<String> courierPayDriverLineItemGroupIds;
    private final String id;
    private final String driverId;
    private final String courierOrgId;
    private final List<String> taskGroupIds;
    private final double statementAmount;
    private final Optional<StatementStatusEnum> statementStatus;
    private final Optional<OffsetDateTime> statementCompletedAtTimestamp;
    private final Optional<String> statementCompletedByUserId;
    private final OffsetDateTime statementCreatedAtTimestamp;
    private final String statementCreatedByUserId;
    private final Map<String, Object> additionalProperties;

    private CourierPayDriverStatement1(int schemaVersion, List<String> courierPayDriverLineItemGroupIds, String id, String driverId, String courierOrgId, List<String> taskGroupIds, double statementAmount, Optional<StatementStatusEnum> statementStatus, Optional<OffsetDateTime> statementCompletedAtTimestamp, Optional<String> statementCompletedByUserId, OffsetDateTime statementCreatedAtTimestamp, String statementCreatedByUserId, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.courierPayDriverLineItemGroupIds = courierPayDriverLineItemGroupIds;
        this.id = id;
        this.driverId = driverId;
        this.courierOrgId = courierOrgId;
        this.taskGroupIds = taskGroupIds;
        this.statementAmount = statementAmount;
        this.statementStatus = statementStatus;
        this.statementCompletedAtTimestamp = statementCompletedAtTimestamp;
        this.statementCompletedByUserId = statementCompletedByUserId;
        this.statementCreatedAtTimestamp = statementCreatedAtTimestamp;
        this.statementCreatedByUserId = statementCreatedByUserId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="courier_pay_driver_line_item_group_ids")
    public List<String> getCourierPayDriverLineItemGroupIds() {
        return this.courierPayDriverLineItemGroupIds;
    }

    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="driver_id")
    public String getDriverId() {
        return this.driverId;
    }

    @JsonProperty(value="courier_org_id")
    public String getCourierOrgId() {
        return this.courierOrgId;
    }

    @JsonProperty(value="task_group_ids")
    public List<String> getTaskGroupIds() {
        return this.taskGroupIds;
    }

    @JsonProperty(value="statement_amount")
    public double getStatementAmount() {
        return this.statementAmount;
    }

    @JsonProperty(value="statement_status")
    public Optional<StatementStatusEnum> getStatementStatus() {
        return this.statementStatus;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getStatementCompletedAtTimestamp() {
        if (this.statementCompletedAtTimestamp == null) {
            return Optional.empty();
        }
        return this.statementCompletedAtTimestamp;
    }

    @JsonIgnore
    public Optional<String> getStatementCompletedByUserId() {
        if (this.statementCompletedByUserId == null) {
            return Optional.empty();
        }
        return this.statementCompletedByUserId;
    }

    @JsonProperty(value="statement_created_at_timestamp")
    public OffsetDateTime getStatementCreatedAtTimestamp() {
        return this.statementCreatedAtTimestamp;
    }

    @JsonProperty(value="statement_created_by_user_id")
    public String getStatementCreatedByUserId() {
        return this.statementCreatedByUserId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="statement_completed_at_timestamp")
    private Optional<OffsetDateTime> _getStatementCompletedAtTimestamp() {
        return this.statementCompletedAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="statement_completed_by_user_id")
    private Optional<String> _getStatementCompletedByUserId() {
        return this.statementCompletedByUserId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CourierPayDriverStatement1 && this.equalTo((CourierPayDriverStatement1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CourierPayDriverStatement1 other) {
        return this.schemaVersion == other.schemaVersion && this.courierPayDriverLineItemGroupIds.equals(other.courierPayDriverLineItemGroupIds) && this.id.equals(other.id) && this.driverId.equals(other.driverId) && this.courierOrgId.equals(other.courierOrgId) && this.taskGroupIds.equals(other.taskGroupIds) && this.statementAmount == other.statementAmount && this.statementStatus.equals(other.statementStatus) && this.statementCompletedAtTimestamp.equals(other.statementCompletedAtTimestamp) && this.statementCompletedByUserId.equals(other.statementCompletedByUserId) && this.statementCreatedAtTimestamp.equals(other.statementCreatedAtTimestamp) && this.statementCreatedByUserId.equals(other.statementCreatedByUserId);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.courierPayDriverLineItemGroupIds, this.id, this.driverId, this.courierOrgId, this.taskGroupIds, this.statementAmount, this.statementStatus, this.statementCompletedAtTimestamp, this.statementCompletedByUserId, this.statementCreatedAtTimestamp, this.statementCreatedByUserId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    IdStage,
    DriverIdStage,
    CourierOrgIdStage,
    StatementAmountStage,
    StatementCreatedAtTimestampStage,
    StatementCreatedByUserIdStage,
    _FinalStage {
        private int schemaVersion;
        private String id;
        private String driverId;
        private String courierOrgId;
        private double statementAmount;
        private OffsetDateTime statementCreatedAtTimestamp;
        private String statementCreatedByUserId;
        private Optional<String> statementCompletedByUserId = Optional.empty();
        private Optional<OffsetDateTime> statementCompletedAtTimestamp = Optional.empty();
        private Optional<StatementStatusEnum> statementStatus = Optional.empty();
        private List<String> taskGroupIds = new ArrayList<String>();
        private List<String> courierPayDriverLineItemGroupIds = new ArrayList<String>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CourierPayDriverStatement1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.courierPayDriverLineItemGroupIds(other.getCourierPayDriverLineItemGroupIds());
            this.id(other.getId());
            this.driverId(other.getDriverId());
            this.courierOrgId(other.getCourierOrgId());
            this.taskGroupIds(other.getTaskGroupIds());
            this.statementAmount(other.getStatementAmount());
            this.statementStatus(other.getStatementStatus());
            this.statementCompletedAtTimestamp(other.getStatementCompletedAtTimestamp());
            this.statementCompletedByUserId(other.getStatementCompletedByUserId());
            this.statementCreatedAtTimestamp(other.getStatementCreatedAtTimestamp());
            this.statementCreatedByUserId(other.getStatementCreatedByUserId());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public IdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="_id")
        public DriverIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="driver_id")
        public CourierOrgIdStage driverId(@NotNull String driverId) {
            this.driverId = Objects.requireNonNull(driverId, "driverId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="courier_org_id")
        public StatementAmountStage courierOrgId(@NotNull String courierOrgId) {
            this.courierOrgId = Objects.requireNonNull(courierOrgId, "courierOrgId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="statement_amount")
        public StatementCreatedAtTimestampStage statementAmount(double statementAmount) {
            this.statementAmount = statementAmount;
            return this;
        }

        @Override
        @JsonSetter(value="statement_created_at_timestamp")
        public StatementCreatedByUserIdStage statementCreatedAtTimestamp(@NotNull OffsetDateTime statementCreatedAtTimestamp) {
            this.statementCreatedAtTimestamp = Objects.requireNonNull(statementCreatedAtTimestamp, "statementCreatedAtTimestamp must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="statement_created_by_user_id")
        public _FinalStage statementCreatedByUserId(@NotNull String statementCreatedByUserId) {
            this.statementCreatedByUserId = Objects.requireNonNull(statementCreatedByUserId, "statementCreatedByUserId must not be null");
            return this;
        }

        @Override
        public _FinalStage statementCompletedByUserId(Nullable<String> statementCompletedByUserId) {
            this.statementCompletedByUserId = statementCompletedByUserId.isNull() ? null : (statementCompletedByUserId.isEmpty() ? Optional.empty() : Optional.of(statementCompletedByUserId.get()));
            return this;
        }

        @Override
        public _FinalStage statementCompletedByUserId(String statementCompletedByUserId) {
            this.statementCompletedByUserId = Optional.ofNullable(statementCompletedByUserId);
            return this;
        }

        @Override
        @JsonSetter(value="statement_completed_by_user_id", nulls=Nulls.SKIP)
        public _FinalStage statementCompletedByUserId(Optional<String> statementCompletedByUserId) {
            this.statementCompletedByUserId = statementCompletedByUserId;
            return this;
        }

        @Override
        public _FinalStage statementCompletedAtTimestamp(Nullable<OffsetDateTime> statementCompletedAtTimestamp) {
            this.statementCompletedAtTimestamp = statementCompletedAtTimestamp.isNull() ? null : (statementCompletedAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(statementCompletedAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage statementCompletedAtTimestamp(OffsetDateTime statementCompletedAtTimestamp) {
            this.statementCompletedAtTimestamp = Optional.ofNullable(statementCompletedAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="statement_completed_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage statementCompletedAtTimestamp(Optional<OffsetDateTime> statementCompletedAtTimestamp) {
            this.statementCompletedAtTimestamp = statementCompletedAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage statementStatus(StatementStatusEnum statementStatus) {
            this.statementStatus = Optional.ofNullable(statementStatus);
            return this;
        }

        @Override
        @JsonSetter(value="statement_status", nulls=Nulls.SKIP)
        public _FinalStage statementStatus(Optional<StatementStatusEnum> statementStatus) {
            this.statementStatus = statementStatus;
            return this;
        }

        @Override
        public _FinalStage addAllTaskGroupIds(List<String> taskGroupIds) {
            if (taskGroupIds != null) {
                this.taskGroupIds.addAll(taskGroupIds);
            }
            return this;
        }

        @Override
        public _FinalStage addTaskGroupIds(String taskGroupIds) {
            this.taskGroupIds.add(taskGroupIds);
            return this;
        }

        @Override
        @JsonSetter(value="task_group_ids", nulls=Nulls.SKIP)
        public _FinalStage taskGroupIds(List<String> taskGroupIds) {
            this.taskGroupIds.clear();
            if (taskGroupIds != null) {
                this.taskGroupIds.addAll(taskGroupIds);
            }
            return this;
        }

        @Override
        public _FinalStage addAllCourierPayDriverLineItemGroupIds(List<String> courierPayDriverLineItemGroupIds) {
            if (courierPayDriverLineItemGroupIds != null) {
                this.courierPayDriverLineItemGroupIds.addAll(courierPayDriverLineItemGroupIds);
            }
            return this;
        }

        @Override
        public _FinalStage addCourierPayDriverLineItemGroupIds(String courierPayDriverLineItemGroupIds) {
            this.courierPayDriverLineItemGroupIds.add(courierPayDriverLineItemGroupIds);
            return this;
        }

        @Override
        @JsonSetter(value="courier_pay_driver_line_item_group_ids", nulls=Nulls.SKIP)
        public _FinalStage courierPayDriverLineItemGroupIds(List<String> courierPayDriverLineItemGroupIds) {
            this.courierPayDriverLineItemGroupIds.clear();
            if (courierPayDriverLineItemGroupIds != null) {
                this.courierPayDriverLineItemGroupIds.addAll(courierPayDriverLineItemGroupIds);
            }
            return this;
        }

        @Override
        public CourierPayDriverStatement1 build() {
            return new CourierPayDriverStatement1(this.schemaVersion, this.courierPayDriverLineItemGroupIds, this.id, this.driverId, this.courierOrgId, this.taskGroupIds, this.statementAmount, this.statementStatus, this.statementCompletedAtTimestamp, this.statementCompletedByUserId, this.statementCreatedAtTimestamp, this.statementCreatedByUserId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CourierPayDriverStatement1 build();

        public _FinalStage courierPayDriverLineItemGroupIds(List<String> var1);

        public _FinalStage addCourierPayDriverLineItemGroupIds(String var1);

        public _FinalStage addAllCourierPayDriverLineItemGroupIds(List<String> var1);

        public _FinalStage taskGroupIds(List<String> var1);

        public _FinalStage addTaskGroupIds(String var1);

        public _FinalStage addAllTaskGroupIds(List<String> var1);

        public _FinalStage statementStatus(Optional<StatementStatusEnum> var1);

        public _FinalStage statementStatus(StatementStatusEnum var1);

        public _FinalStage statementCompletedAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage statementCompletedAtTimestamp(OffsetDateTime var1);

        public _FinalStage statementCompletedAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage statementCompletedByUserId(Optional<String> var1);

        public _FinalStage statementCompletedByUserId(String var1);

        public _FinalStage statementCompletedByUserId(Nullable<String> var1);
    }

    public static interface StatementCreatedByUserIdStage {
        public _FinalStage statementCreatedByUserId(@NotNull String var1);
    }

    public static interface StatementCreatedAtTimestampStage {
        public StatementCreatedByUserIdStage statementCreatedAtTimestamp(@NotNull OffsetDateTime var1);
    }

    public static interface StatementAmountStage {
        public StatementCreatedAtTimestampStage statementAmount(double var1);
    }

    public static interface CourierOrgIdStage {
        public StatementAmountStage courierOrgId(@NotNull String var1);
    }

    public static interface DriverIdStage {
        public CourierOrgIdStage driverId(@NotNull String var1);
    }

    public static interface IdStage {
        public DriverIdStage id(@NotNull String var1);
    }

    public static interface SchemaVersionStage {
        public IdStage schemaVersion(int var1);

        public Builder from(CourierPayDriverStatement1 var1);
    }
}

