/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DriverUpdateRes {
    private final boolean driverUpdated;
    private final int taskGroupTrackingCount;
    private final int cargoTrackingCount;
    private final Map<String, Object> additionalProperties;

    private DriverUpdateRes(boolean driverUpdated, int taskGroupTrackingCount, int cargoTrackingCount, Map<String, Object> additionalProperties) {
        this.driverUpdated = driverUpdated;
        this.taskGroupTrackingCount = taskGroupTrackingCount;
        this.cargoTrackingCount = cargoTrackingCount;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="driver_updated")
    public boolean getDriverUpdated() {
        return this.driverUpdated;
    }

    @JsonProperty(value="task_group_tracking_count")
    public int getTaskGroupTrackingCount() {
        return this.taskGroupTrackingCount;
    }

    @JsonProperty(value="cargo_tracking_count")
    public int getCargoTrackingCount() {
        return this.cargoTrackingCount;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DriverUpdateRes && this.equalTo((DriverUpdateRes)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DriverUpdateRes other) {
        return this.driverUpdated == other.driverUpdated && this.taskGroupTrackingCount == other.taskGroupTrackingCount && this.cargoTrackingCount == other.cargoTrackingCount;
    }

    public int hashCode() {
        return Objects.hash(this.driverUpdated, this.taskGroupTrackingCount, this.cargoTrackingCount);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DriverUpdatedStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DriverUpdatedStage,
    TaskGroupTrackingCountStage,
    CargoTrackingCountStage,
    _FinalStage {
        private boolean driverUpdated;
        private int taskGroupTrackingCount;
        private int cargoTrackingCount;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DriverUpdateRes other) {
            this.driverUpdated(other.getDriverUpdated());
            this.taskGroupTrackingCount(other.getTaskGroupTrackingCount());
            this.cargoTrackingCount(other.getCargoTrackingCount());
            return this;
        }

        @Override
        @JsonSetter(value="driver_updated")
        public TaskGroupTrackingCountStage driverUpdated(boolean driverUpdated) {
            this.driverUpdated = driverUpdated;
            return this;
        }

        @Override
        @JsonSetter(value="task_group_tracking_count")
        public CargoTrackingCountStage taskGroupTrackingCount(int taskGroupTrackingCount) {
            this.taskGroupTrackingCount = taskGroupTrackingCount;
            return this;
        }

        @Override
        @JsonSetter(value="cargo_tracking_count")
        public _FinalStage cargoTrackingCount(int cargoTrackingCount) {
            this.cargoTrackingCount = cargoTrackingCount;
            return this;
        }

        @Override
        public DriverUpdateRes build() {
            return new DriverUpdateRes(this.driverUpdated, this.taskGroupTrackingCount, this.cargoTrackingCount, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DriverUpdateRes build();
    }

    public static interface CargoTrackingCountStage {
        public _FinalStage cargoTrackingCount(int var1);
    }

    public static interface TaskGroupTrackingCountStage {
        public CargoTrackingCountStage taskGroupTrackingCount(int var1);
    }

    public static interface DriverUpdatedStage {
        public TaskGroupTrackingCountStage driverUpdated(boolean var1);

        public Builder from(DriverUpdateRes var1);
    }
}

