/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ForwarderCourierConnection1 {
    private final int schemaVersion;
    private final String forwarderOrgId;
    private final String courierOrgId;
    private final Optional<Boolean> connected;
    private final Optional<String> forwarderCustomerIdForCourierStripeConnectAccount;
    private final String id;
    private final Map<String, Object> additionalProperties;

    private ForwarderCourierConnection1(int schemaVersion, String forwarderOrgId, String courierOrgId, Optional<Boolean> connected, Optional<String> forwarderCustomerIdForCourierStripeConnectAccount, String id, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.forwarderOrgId = forwarderOrgId;
        this.courierOrgId = courierOrgId;
        this.connected = connected;
        this.forwarderCustomerIdForCourierStripeConnectAccount = forwarderCustomerIdForCourierStripeConnectAccount;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="forwarder_org_id")
    public String getForwarderOrgId() {
        return this.forwarderOrgId;
    }

    @JsonProperty(value="courier_org_id")
    public String getCourierOrgId() {
        return this.courierOrgId;
    }

    @JsonProperty(value="connected")
    public Optional<Boolean> getConnected() {
        return this.connected;
    }

    @JsonIgnore
    public Optional<String> getForwarderCustomerIdForCourierStripeConnectAccount() {
        if (this.forwarderCustomerIdForCourierStripeConnectAccount == null) {
            return Optional.empty();
        }
        return this.forwarderCustomerIdForCourierStripeConnectAccount;
    }

    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="forwarder_customer_id_for_courier_stripe_connect_account")
    private Optional<String> _getForwarderCustomerIdForCourierStripeConnectAccount() {
        return this.forwarderCustomerIdForCourierStripeConnectAccount;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ForwarderCourierConnection1 && this.equalTo((ForwarderCourierConnection1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ForwarderCourierConnection1 other) {
        return this.schemaVersion == other.schemaVersion && this.forwarderOrgId.equals(other.forwarderOrgId) && this.courierOrgId.equals(other.courierOrgId) && this.connected.equals(other.connected) && this.forwarderCustomerIdForCourierStripeConnectAccount.equals(other.forwarderCustomerIdForCourierStripeConnectAccount) && this.id.equals(other.id);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.forwarderOrgId, this.courierOrgId, this.connected, this.forwarderCustomerIdForCourierStripeConnectAccount, this.id);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    ForwarderOrgIdStage,
    CourierOrgIdStage,
    IdStage,
    _FinalStage {
        private int schemaVersion;
        private String forwarderOrgId;
        private String courierOrgId;
        private String id;
        private Optional<String> forwarderCustomerIdForCourierStripeConnectAccount = Optional.empty();
        private Optional<Boolean> connected = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ForwarderCourierConnection1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.forwarderOrgId(other.getForwarderOrgId());
            this.courierOrgId(other.getCourierOrgId());
            this.connected(other.getConnected());
            this.forwarderCustomerIdForCourierStripeConnectAccount(other.getForwarderCustomerIdForCourierStripeConnectAccount());
            this.id(other.getId());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public ForwarderOrgIdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="forwarder_org_id")
        public CourierOrgIdStage forwarderOrgId(@NotNull String forwarderOrgId) {
            this.forwarderOrgId = Objects.requireNonNull(forwarderOrgId, "forwarderOrgId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="courier_org_id")
        public IdStage courierOrgId(@NotNull String courierOrgId) {
            this.courierOrgId = Objects.requireNonNull(courierOrgId, "courierOrgId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public _FinalStage forwarderCustomerIdForCourierStripeConnectAccount(Nullable<String> forwarderCustomerIdForCourierStripeConnectAccount) {
            this.forwarderCustomerIdForCourierStripeConnectAccount = forwarderCustomerIdForCourierStripeConnectAccount.isNull() ? null : (forwarderCustomerIdForCourierStripeConnectAccount.isEmpty() ? Optional.empty() : Optional.of(forwarderCustomerIdForCourierStripeConnectAccount.get()));
            return this;
        }

        @Override
        public _FinalStage forwarderCustomerIdForCourierStripeConnectAccount(String forwarderCustomerIdForCourierStripeConnectAccount) {
            this.forwarderCustomerIdForCourierStripeConnectAccount = Optional.ofNullable(forwarderCustomerIdForCourierStripeConnectAccount);
            return this;
        }

        @Override
        @JsonSetter(value="forwarder_customer_id_for_courier_stripe_connect_account", nulls=Nulls.SKIP)
        public _FinalStage forwarderCustomerIdForCourierStripeConnectAccount(Optional<String> forwarderCustomerIdForCourierStripeConnectAccount) {
            this.forwarderCustomerIdForCourierStripeConnectAccount = forwarderCustomerIdForCourierStripeConnectAccount;
            return this;
        }

        @Override
        public _FinalStage connected(Boolean connected) {
            this.connected = Optional.ofNullable(connected);
            return this;
        }

        @Override
        @JsonSetter(value="connected", nulls=Nulls.SKIP)
        public _FinalStage connected(Optional<Boolean> connected) {
            this.connected = connected;
            return this;
        }

        @Override
        public ForwarderCourierConnection1 build() {
            return new ForwarderCourierConnection1(this.schemaVersion, this.forwarderOrgId, this.courierOrgId, this.connected, this.forwarderCustomerIdForCourierStripeConnectAccount, this.id, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ForwarderCourierConnection1 build();

        public _FinalStage connected(Optional<Boolean> var1);

        public _FinalStage connected(Boolean var1);

        public _FinalStage forwarderCustomerIdForCourierStripeConnectAccount(Optional<String> var1);

        public _FinalStage forwarderCustomerIdForCourierStripeConnectAccount(String var1);

        public _FinalStage forwarderCustomerIdForCourierStripeConnectAccount(Nullable<String> var1);
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);
    }

    public static interface CourierOrgIdStage {
        public IdStage courierOrgId(@NotNull String var1);
    }

    public static interface ForwarderOrgIdStage {
        public CourierOrgIdStage forwarderOrgId(@NotNull String var1);
    }

    public static interface SchemaVersionStage {
        public ForwarderOrgIdStage schemaVersion(int var1);

        public Builder from(ForwarderCourierConnection1 var1);
    }
}

