/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GenerateInvoiceRes {
    private final String invoiceId;
    private final String invoiceUrl;
    private final int amountDue;
    private final int dueDate;
    private final Map<String, Object> additionalProperties;

    private GenerateInvoiceRes(String invoiceId, String invoiceUrl, int amountDue, int dueDate, Map<String, Object> additionalProperties) {
        this.invoiceId = invoiceId;
        this.invoiceUrl = invoiceUrl;
        this.amountDue = amountDue;
        this.dueDate = dueDate;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="invoice_id")
    public String getInvoiceId() {
        return this.invoiceId;
    }

    @JsonProperty(value="invoice_url")
    public String getInvoiceUrl() {
        return this.invoiceUrl;
    }

    @JsonProperty(value="amount_due")
    public int getAmountDue() {
        return this.amountDue;
    }

    @JsonProperty(value="due_date")
    public int getDueDate() {
        return this.dueDate;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GenerateInvoiceRes && this.equalTo((GenerateInvoiceRes)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GenerateInvoiceRes other) {
        return this.invoiceId.equals(other.invoiceId) && this.invoiceUrl.equals(other.invoiceUrl) && this.amountDue == other.amountDue && this.dueDate == other.dueDate;
    }

    public int hashCode() {
        return Objects.hash(this.invoiceId, this.invoiceUrl, this.amountDue, this.dueDate);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static InvoiceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements InvoiceIdStage,
    InvoiceUrlStage,
    AmountDueStage,
    DueDateStage,
    _FinalStage {
        private String invoiceId;
        private String invoiceUrl;
        private int amountDue;
        private int dueDate;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GenerateInvoiceRes other) {
            this.invoiceId(other.getInvoiceId());
            this.invoiceUrl(other.getInvoiceUrl());
            this.amountDue(other.getAmountDue());
            this.dueDate(other.getDueDate());
            return this;
        }

        @Override
        @JsonSetter(value="invoice_id")
        public InvoiceUrlStage invoiceId(@NotNull String invoiceId) {
            this.invoiceId = Objects.requireNonNull(invoiceId, "invoiceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="invoice_url")
        public AmountDueStage invoiceUrl(@NotNull String invoiceUrl) {
            this.invoiceUrl = Objects.requireNonNull(invoiceUrl, "invoiceUrl must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="amount_due")
        public DueDateStage amountDue(int amountDue) {
            this.amountDue = amountDue;
            return this;
        }

        @Override
        @JsonSetter(value="due_date")
        public _FinalStage dueDate(int dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        @Override
        public GenerateInvoiceRes build() {
            return new GenerateInvoiceRes(this.invoiceId, this.invoiceUrl, this.amountDue, this.dueDate, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GenerateInvoiceRes build();
    }

    public static interface DueDateStage {
        public _FinalStage dueDate(int var1);
    }

    public static interface AmountDueStage {
        public DueDateStage amountDue(int var1);
    }

    public static interface InvoiceUrlStage {
        public AmountDueStage invoiceUrl(@NotNull String var1);
    }

    public static interface InvoiceIdStage {
        public InvoiceUrlStage invoiceId(@NotNull String var1);

        public Builder from(GenerateInvoiceRes var1);
    }
}

