/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.LineItemEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LineItemClientCreate1 {
    private final int schemaVersion;
    private final LineItemEnum1 item;
    private final double quantity;
    private final double rate;
    private final Optional<String> comment;
    private final Map<String, Object> additionalProperties;

    private LineItemClientCreate1(int schemaVersion, LineItemEnum1 item, double quantity, double rate, Optional<String> comment, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.item = item;
        this.quantity = quantity;
        this.rate = rate;
        this.comment = comment;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="item")
    public LineItemEnum1 getItem() {
        return this.item;
    }

    @JsonProperty(value="quantity")
    public double getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="rate")
    public double getRate() {
        return this.rate;
    }

    @JsonIgnore
    public Optional<String> getComment() {
        if (this.comment == null) {
            return Optional.empty();
        }
        return this.comment;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="comment")
    private Optional<String> _getComment() {
        return this.comment;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LineItemClientCreate1 && this.equalTo((LineItemClientCreate1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LineItemClientCreate1 other) {
        return this.schemaVersion == other.schemaVersion && this.item.equals(other.item) && this.quantity == other.quantity && this.rate == other.rate && this.comment.equals(other.comment);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.item, this.quantity, this.rate, this.comment);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    ItemStage,
    QuantityStage,
    RateStage,
    _FinalStage {
        private int schemaVersion;
        private LineItemEnum1 item;
        private double quantity;
        private double rate;
        private Optional<String> comment = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(LineItemClientCreate1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.item(other.getItem());
            this.quantity(other.getQuantity());
            this.rate(other.getRate());
            this.comment(other.getComment());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public ItemStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="item")
        public QuantityStage item(@NotNull LineItemEnum1 item) {
            this.item = Objects.requireNonNull(item, "item must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="quantity")
        public RateStage quantity(double quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        @JsonSetter(value="rate")
        public _FinalStage rate(double rate) {
            this.rate = rate;
            return this;
        }

        @Override
        public _FinalStage comment(Nullable<String> comment) {
            this.comment = comment.isNull() ? null : (comment.isEmpty() ? Optional.empty() : Optional.of(comment.get()));
            return this;
        }

        @Override
        public _FinalStage comment(String comment) {
            this.comment = Optional.ofNullable(comment);
            return this;
        }

        @Override
        @JsonSetter(value="comment", nulls=Nulls.SKIP)
        public _FinalStage comment(Optional<String> comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public LineItemClientCreate1 build() {
            return new LineItemClientCreate1(this.schemaVersion, this.item, this.quantity, this.rate, this.comment, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public LineItemClientCreate1 build();

        public _FinalStage comment(Optional<String> var1);

        public _FinalStage comment(String var1);

        public _FinalStage comment(Nullable<String> var1);
    }

    public static interface RateStage {
        public _FinalStage rate(double var1);
    }

    public static interface QuantityStage {
        public RateStage quantity(double var1);
    }

    public static interface ItemStage {
        public QuantityStage item(@NotNull LineItemEnum1 var1);
    }

    public static interface SchemaVersionStage {
        public ItemStage schemaVersion(int var1);

        public Builder from(LineItemClientCreate1 var1);
    }
}

