/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.OrderExpanded;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OrdersExpandedListRes {
    private final List<OrderExpanded> ordersExpanded;
    private final int totalCount;
    private final Map<String, Object> additionalProperties;

    private OrdersExpandedListRes(List<OrderExpanded> ordersExpanded, int totalCount, Map<String, Object> additionalProperties) {
        this.ordersExpanded = ordersExpanded;
        this.totalCount = totalCount;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="orders_expanded")
    public List<OrderExpanded> getOrdersExpanded() {
        return this.ordersExpanded;
    }

    @JsonProperty(value="total_count")
    public int getTotalCount() {
        return this.totalCount;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OrdersExpandedListRes && this.equalTo((OrdersExpandedListRes)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrdersExpandedListRes other) {
        return this.ordersExpanded.equals(other.ordersExpanded) && this.totalCount == other.totalCount;
    }

    public int hashCode() {
        return Objects.hash(this.ordersExpanded, this.totalCount);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalCountStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TotalCountStage,
    _FinalStage {
        private int totalCount;
        private List<OrderExpanded> ordersExpanded = new ArrayList<OrderExpanded>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(OrdersExpandedListRes other) {
            this.ordersExpanded(other.getOrdersExpanded());
            this.totalCount(other.getTotalCount());
            return this;
        }

        @Override
        @JsonSetter(value="total_count")
        public _FinalStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        public _FinalStage addAllOrdersExpanded(List<OrderExpanded> ordersExpanded) {
            if (ordersExpanded != null) {
                this.ordersExpanded.addAll(ordersExpanded);
            }
            return this;
        }

        @Override
        public _FinalStage addOrdersExpanded(OrderExpanded ordersExpanded) {
            this.ordersExpanded.add(ordersExpanded);
            return this;
        }

        @Override
        @JsonSetter(value="orders_expanded", nulls=Nulls.SKIP)
        public _FinalStage ordersExpanded(List<OrderExpanded> ordersExpanded) {
            this.ordersExpanded.clear();
            if (ordersExpanded != null) {
                this.ordersExpanded.addAll(ordersExpanded);
            }
            return this;
        }

        @Override
        public OrdersExpandedListRes build() {
            return new OrdersExpandedListRes(this.ordersExpanded, this.totalCount, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public OrdersExpandedListRes build();

        public _FinalStage ordersExpanded(List<OrderExpanded> var1);

        public _FinalStage addOrdersExpanded(OrderExpanded var1);

        public _FinalStage addAllOrdersExpanded(List<OrderExpanded> var1);
    }

    public static interface TotalCountStage {
        public _FinalStage totalCount(int var1);

        public Builder from(OrdersExpandedListRes var1);
    }
}

