/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OrdersNewDraftRes {
    private final String orderId;
    private final String orderShortId;
    private final Map<String, Object> additionalProperties;

    private OrdersNewDraftRes(String orderId, String orderShortId, Map<String, Object> additionalProperties) {
        this.orderId = orderId;
        this.orderShortId = orderShortId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="order_id")
    public String getOrderId() {
        return this.orderId;
    }

    @JsonProperty(value="order_short_id")
    public String getOrderShortId() {
        return this.orderShortId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OrdersNewDraftRes && this.equalTo((OrdersNewDraftRes)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrdersNewDraftRes other) {
        return this.orderId.equals(other.orderId) && this.orderShortId.equals(other.orderShortId);
    }

    public int hashCode() {
        return Objects.hash(this.orderId, this.orderShortId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OrderIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OrderIdStage,
    OrderShortIdStage,
    _FinalStage {
        private String orderId;
        private String orderShortId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(OrdersNewDraftRes other) {
            this.orderId(other.getOrderId());
            this.orderShortId(other.getOrderShortId());
            return this;
        }

        @Override
        @JsonSetter(value="order_id")
        public OrderShortIdStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="order_short_id")
        public _FinalStage orderShortId(@NotNull String orderShortId) {
            this.orderShortId = Objects.requireNonNull(orderShortId, "orderShortId must not be null");
            return this;
        }

        @Override
        public OrdersNewDraftRes build() {
            return new OrdersNewDraftRes(this.orderId, this.orderShortId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public OrdersNewDraftRes build();
    }

    public static interface OrderShortIdStage {
        public _FinalStage orderShortId(@NotNull String var1);
    }

    public static interface OrderIdStage {
        public OrderShortIdStage orderId(@NotNull String var1);

        public Builder from(OrdersNewDraftRes var1);
    }
}

