/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.Driver1;
import com.chrt.api.types.OrgMemberDetails;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OrgMembersAndDrivers {
    private final OrgMemberDetails orgMember;
    private final Optional<Driver1> driver;
    private final Map<String, Object> additionalProperties;

    private OrgMembersAndDrivers(OrgMemberDetails orgMember, Optional<Driver1> driver, Map<String, Object> additionalProperties) {
        this.orgMember = orgMember;
        this.driver = driver;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="org_member")
    public OrgMemberDetails getOrgMember() {
        return this.orgMember;
    }

    @JsonIgnore
    public Optional<Driver1> getDriver() {
        if (this.driver == null) {
            return Optional.empty();
        }
        return this.driver;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="driver")
    private Optional<Driver1> _getDriver() {
        return this.driver;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OrgMembersAndDrivers && this.equalTo((OrgMembersAndDrivers)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrgMembersAndDrivers other) {
        return this.orgMember.equals(other.orgMember) && this.driver.equals(other.driver);
    }

    public int hashCode() {
        return Objects.hash(this.orgMember, this.driver);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OrgMemberStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OrgMemberStage,
    _FinalStage {
        private OrgMemberDetails orgMember;
        private Optional<Driver1> driver = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(OrgMembersAndDrivers other) {
            this.orgMember(other.getOrgMember());
            this.driver(other.getDriver());
            return this;
        }

        @Override
        @JsonSetter(value="org_member")
        public _FinalStage orgMember(@NotNull OrgMemberDetails orgMember) {
            this.orgMember = Objects.requireNonNull(orgMember, "orgMember must not be null");
            return this;
        }

        @Override
        public _FinalStage driver(Nullable<Driver1> driver) {
            this.driver = driver.isNull() ? null : (driver.isEmpty() ? Optional.empty() : Optional.of(driver.get()));
            return this;
        }

        @Override
        public _FinalStage driver(Driver1 driver) {
            this.driver = Optional.ofNullable(driver);
            return this;
        }

        @Override
        @JsonSetter(value="driver", nulls=Nulls.SKIP)
        public _FinalStage driver(Optional<Driver1> driver) {
            this.driver = driver;
            return this;
        }

        @Override
        public OrgMembersAndDrivers build() {
            return new OrgMembersAndDrivers(this.orgMember, this.driver, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public OrgMembersAndDrivers build();

        public _FinalStage driver(Optional<Driver1> var1);

        public _FinalStage driver(Driver1 var1);

        public _FinalStage driver(Nullable<Driver1> var1);
    }

    public static interface OrgMemberStage {
        public _FinalStage orgMember(@NotNull OrgMemberDetails var1);

        public Builder from(OrgMembersAndDrivers var1);
    }
}

