/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.OrgTypeEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OrgPublicData1 {
    private final int schemaVersion;
    private final OrgTypeEnum orgType;
    private final String orgId;
    private final Optional<String> companyName;
    private final Optional<String> handle;
    private final String id;
    private final Map<String, Object> additionalProperties;

    private OrgPublicData1(int schemaVersion, OrgTypeEnum orgType, String orgId, Optional<String> companyName, Optional<String> handle, String id, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.orgType = orgType;
        this.orgId = orgId;
        this.companyName = companyName;
        this.handle = handle;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="org_type")
    public OrgTypeEnum getOrgType() {
        return this.orgType;
    }

    @JsonProperty(value="org_id")
    public String getOrgId() {
        return this.orgId;
    }

    @JsonIgnore
    public Optional<String> getCompanyName() {
        if (this.companyName == null) {
            return Optional.empty();
        }
        return this.companyName;
    }

    @JsonIgnore
    public Optional<String> getHandle() {
        if (this.handle == null) {
            return Optional.empty();
        }
        return this.handle;
    }

    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="company_name")
    private Optional<String> _getCompanyName() {
        return this.companyName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="handle")
    private Optional<String> _getHandle() {
        return this.handle;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OrgPublicData1 && this.equalTo((OrgPublicData1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrgPublicData1 other) {
        return this.schemaVersion == other.schemaVersion && this.orgType.equals(other.orgType) && this.orgId.equals(other.orgId) && this.companyName.equals(other.companyName) && this.handle.equals(other.handle) && this.id.equals(other.id);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.orgType, this.orgId, this.companyName, this.handle, this.id);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    OrgTypeStage,
    OrgIdStage,
    IdStage,
    _FinalStage {
        private int schemaVersion;
        private OrgTypeEnum orgType;
        private String orgId;
        private String id;
        private Optional<String> handle = Optional.empty();
        private Optional<String> companyName = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(OrgPublicData1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.orgType(other.getOrgType());
            this.orgId(other.getOrgId());
            this.companyName(other.getCompanyName());
            this.handle(other.getHandle());
            this.id(other.getId());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public OrgTypeStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="org_type")
        public OrgIdStage orgType(@NotNull OrgTypeEnum orgType) {
            this.orgType = Objects.requireNonNull(orgType, "orgType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="org_id")
        public IdStage orgId(@NotNull String orgId) {
            this.orgId = Objects.requireNonNull(orgId, "orgId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public _FinalStage handle(Nullable<String> handle) {
            this.handle = handle.isNull() ? null : (handle.isEmpty() ? Optional.empty() : Optional.of(handle.get()));
            return this;
        }

        @Override
        public _FinalStage handle(String handle) {
            this.handle = Optional.ofNullable(handle);
            return this;
        }

        @Override
        @JsonSetter(value="handle", nulls=Nulls.SKIP)
        public _FinalStage handle(Optional<String> handle) {
            this.handle = handle;
            return this;
        }

        @Override
        public _FinalStage companyName(Nullable<String> companyName) {
            this.companyName = companyName.isNull() ? null : (companyName.isEmpty() ? Optional.empty() : Optional.of(companyName.get()));
            return this;
        }

        @Override
        public _FinalStage companyName(String companyName) {
            this.companyName = Optional.ofNullable(companyName);
            return this;
        }

        @Override
        @JsonSetter(value="company_name", nulls=Nulls.SKIP)
        public _FinalStage companyName(Optional<String> companyName) {
            this.companyName = companyName;
            return this;
        }

        @Override
        public OrgPublicData1 build() {
            return new OrgPublicData1(this.schemaVersion, this.orgType, this.orgId, this.companyName, this.handle, this.id, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public OrgPublicData1 build();

        public _FinalStage companyName(Optional<String> var1);

        public _FinalStage companyName(String var1);

        public _FinalStage companyName(Nullable<String> var1);

        public _FinalStage handle(Optional<String> var1);

        public _FinalStage handle(String var1);

        public _FinalStage handle(Nullable<String> var1);
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);
    }

    public static interface OrgIdStage {
        public IdStage orgId(@NotNull String var1);
    }

    public static interface OrgTypeStage {
        public OrgIdStage orgType(@NotNull OrgTypeEnum var1);
    }

    public static interface SchemaVersionStage {
        public OrgTypeStage schemaVersion(int var1);

        public Builder from(OrgPublicData1 var1);
    }
}

