/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class OrgRoleEnum {
    public static final OrgRoleEnum OWNER = new OrgRoleEnum(Value.OWNER, "owner");
    public static final OrgRoleEnum ADMINISTRATOR = new OrgRoleEnum(Value.ADMINISTRATOR, "administrator");
    public static final OrgRoleEnum OPERATOR = new OrgRoleEnum(Value.OPERATOR, "operator");
    public static final OrgRoleEnum DRIVER = new OrgRoleEnum(Value.DRIVER, "driver");
    private final Value value;
    private final String string;

    OrgRoleEnum(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof OrgRoleEnum && this.string.equals(((OrgRoleEnum)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case OWNER: {
                return visitor.visitOwner();
            }
            case ADMINISTRATOR: {
                return visitor.visitAdministrator();
            }
            case OPERATOR: {
                return visitor.visitOperator();
            }
            case DRIVER: {
                return visitor.visitDriver();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static OrgRoleEnum valueOf(String value) {
        switch (value) {
            case "owner": {
                return OWNER;
            }
            case "administrator": {
                return ADMINISTRATOR;
            }
            case "operator": {
                return OPERATOR;
            }
            case "driver": {
                return DRIVER;
            }
        }
        return new OrgRoleEnum(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitOwner();

        public T visitAdministrator();

        public T visitOperator();

        public T visitDriver();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        OWNER,
        ADMINISTRATOR,
        OPERATOR,
        DRIVER,
        UNKNOWN;

    }
}

