/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.ShipperPayCourierLineItemGroup1;
import com.chrt.api.types.TaskGroup1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PaymentPreviewResponse {
    private final List<TaskGroup1> taskGroups;
    private final List<ShipperPayCourierLineItemGroup1> lineItemGroups;
    private final double totalAmount;
    private final boolean paymentReady;
    private final Map<String, Object> additionalProperties;

    private PaymentPreviewResponse(List<TaskGroup1> taskGroups, List<ShipperPayCourierLineItemGroup1> lineItemGroups, double totalAmount, boolean paymentReady, Map<String, Object> additionalProperties) {
        this.taskGroups = taskGroups;
        this.lineItemGroups = lineItemGroups;
        this.totalAmount = totalAmount;
        this.paymentReady = paymentReady;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="task_groups")
    public List<TaskGroup1> getTaskGroups() {
        return this.taskGroups;
    }

    @JsonProperty(value="line_item_groups")
    public List<ShipperPayCourierLineItemGroup1> getLineItemGroups() {
        return this.lineItemGroups;
    }

    @JsonProperty(value="total_amount")
    public double getTotalAmount() {
        return this.totalAmount;
    }

    @JsonProperty(value="payment_ready")
    public boolean getPaymentReady() {
        return this.paymentReady;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PaymentPreviewResponse && this.equalTo((PaymentPreviewResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PaymentPreviewResponse other) {
        return this.taskGroups.equals(other.taskGroups) && this.lineItemGroups.equals(other.lineItemGroups) && this.totalAmount == other.totalAmount && this.paymentReady == other.paymentReady;
    }

    public int hashCode() {
        return Objects.hash(this.taskGroups, this.lineItemGroups, this.totalAmount, this.paymentReady);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalAmountStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TotalAmountStage,
    PaymentReadyStage,
    _FinalStage {
        private double totalAmount;
        private boolean paymentReady;
        private List<ShipperPayCourierLineItemGroup1> lineItemGroups = new ArrayList<ShipperPayCourierLineItemGroup1>();
        private List<TaskGroup1> taskGroups = new ArrayList<TaskGroup1>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PaymentPreviewResponse other) {
            this.taskGroups(other.getTaskGroups());
            this.lineItemGroups(other.getLineItemGroups());
            this.totalAmount(other.getTotalAmount());
            this.paymentReady(other.getPaymentReady());
            return this;
        }

        @Override
        @JsonSetter(value="total_amount")
        public PaymentReadyStage totalAmount(double totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        @Override
        @JsonSetter(value="payment_ready")
        public _FinalStage paymentReady(boolean paymentReady) {
            this.paymentReady = paymentReady;
            return this;
        }

        @Override
        public _FinalStage addAllLineItemGroups(List<ShipperPayCourierLineItemGroup1> lineItemGroups) {
            if (lineItemGroups != null) {
                this.lineItemGroups.addAll(lineItemGroups);
            }
            return this;
        }

        @Override
        public _FinalStage addLineItemGroups(ShipperPayCourierLineItemGroup1 lineItemGroups) {
            this.lineItemGroups.add(lineItemGroups);
            return this;
        }

        @Override
        @JsonSetter(value="line_item_groups", nulls=Nulls.SKIP)
        public _FinalStage lineItemGroups(List<ShipperPayCourierLineItemGroup1> lineItemGroups) {
            this.lineItemGroups.clear();
            if (lineItemGroups != null) {
                this.lineItemGroups.addAll(lineItemGroups);
            }
            return this;
        }

        @Override
        public _FinalStage addAllTaskGroups(List<TaskGroup1> taskGroups) {
            if (taskGroups != null) {
                this.taskGroups.addAll(taskGroups);
            }
            return this;
        }

        @Override
        public _FinalStage addTaskGroups(TaskGroup1 taskGroups) {
            this.taskGroups.add(taskGroups);
            return this;
        }

        @Override
        @JsonSetter(value="task_groups", nulls=Nulls.SKIP)
        public _FinalStage taskGroups(List<TaskGroup1> taskGroups) {
            this.taskGroups.clear();
            if (taskGroups != null) {
                this.taskGroups.addAll(taskGroups);
            }
            return this;
        }

        @Override
        public PaymentPreviewResponse build() {
            return new PaymentPreviewResponse(this.taskGroups, this.lineItemGroups, this.totalAmount, this.paymentReady, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PaymentPreviewResponse build();

        public _FinalStage taskGroups(List<TaskGroup1> var1);

        public _FinalStage addTaskGroups(TaskGroup1 var1);

        public _FinalStage addAllTaskGroups(List<TaskGroup1> var1);

        public _FinalStage lineItemGroups(List<ShipperPayCourierLineItemGroup1> var1);

        public _FinalStage addLineItemGroups(ShipperPayCourierLineItemGroup1 var1);

        public _FinalStage addAllLineItemGroups(List<ShipperPayCourierLineItemGroup1> var1);
    }

    public static interface PaymentReadyStage {
        public _FinalStage paymentReady(boolean var1);
    }

    public static interface TotalAmountStage {
        public PaymentReadyStage totalAmount(double var1);

        public Builder from(PaymentPreviewResponse var1);
    }
}

