/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.NotificationChannelEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ShipperNotificationPreferences1 {
    private final int schemaVersion;
    private final Optional<List<String>> emailAddresses;
    private final Optional<List<String>> smsPhoneNumbers;
    private final Optional<List<String>> voicePhoneNumbers;
    private final Optional<Map<String, List<NotificationChannelEnum>>> preferences;
    private final String orgId;
    private final String createdByUserId;
    private final OffsetDateTime createdAtTimestamp;
    private final String id;
    private final Map<String, Object> additionalProperties;

    private ShipperNotificationPreferences1(int schemaVersion, Optional<List<String>> emailAddresses, Optional<List<String>> smsPhoneNumbers, Optional<List<String>> voicePhoneNumbers, Optional<Map<String, List<NotificationChannelEnum>>> preferences, String orgId, String createdByUserId, OffsetDateTime createdAtTimestamp, String id, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.emailAddresses = emailAddresses;
        this.smsPhoneNumbers = smsPhoneNumbers;
        this.voicePhoneNumbers = voicePhoneNumbers;
        this.preferences = preferences;
        this.orgId = orgId;
        this.createdByUserId = createdByUserId;
        this.createdAtTimestamp = createdAtTimestamp;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="email_addresses")
    public Optional<List<String>> getEmailAddresses() {
        return this.emailAddresses;
    }

    @JsonProperty(value="sms_phone_numbers")
    public Optional<List<String>> getSmsPhoneNumbers() {
        return this.smsPhoneNumbers;
    }

    @JsonProperty(value="voice_phone_numbers")
    public Optional<List<String>> getVoicePhoneNumbers() {
        return this.voicePhoneNumbers;
    }

    @JsonProperty(value="preferences")
    public Optional<Map<String, List<NotificationChannelEnum>>> getPreferences() {
        return this.preferences;
    }

    @JsonProperty(value="org_id")
    public String getOrgId() {
        return this.orgId;
    }

    @JsonProperty(value="created_by_user_id")
    public String getCreatedByUserId() {
        return this.createdByUserId;
    }

    @JsonProperty(value="created_at_timestamp")
    public OffsetDateTime getCreatedAtTimestamp() {
        return this.createdAtTimestamp;
    }

    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ShipperNotificationPreferences1 && this.equalTo((ShipperNotificationPreferences1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ShipperNotificationPreferences1 other) {
        return this.schemaVersion == other.schemaVersion && this.emailAddresses.equals(other.emailAddresses) && this.smsPhoneNumbers.equals(other.smsPhoneNumbers) && this.voicePhoneNumbers.equals(other.voicePhoneNumbers) && this.preferences.equals(other.preferences) && this.orgId.equals(other.orgId) && this.createdByUserId.equals(other.createdByUserId) && this.createdAtTimestamp.equals(other.createdAtTimestamp) && this.id.equals(other.id);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.emailAddresses, this.smsPhoneNumbers, this.voicePhoneNumbers, this.preferences, this.orgId, this.createdByUserId, this.createdAtTimestamp, this.id);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    OrgIdStage,
    CreatedByUserIdStage,
    CreatedAtTimestampStage,
    IdStage,
    _FinalStage {
        private int schemaVersion;
        private String orgId;
        private String createdByUserId;
        private OffsetDateTime createdAtTimestamp;
        private String id;
        private Optional<Map<String, List<NotificationChannelEnum>>> preferences = Optional.empty();
        private Optional<List<String>> voicePhoneNumbers = Optional.empty();
        private Optional<List<String>> smsPhoneNumbers = Optional.empty();
        private Optional<List<String>> emailAddresses = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ShipperNotificationPreferences1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.emailAddresses(other.getEmailAddresses());
            this.smsPhoneNumbers(other.getSmsPhoneNumbers());
            this.voicePhoneNumbers(other.getVoicePhoneNumbers());
            this.preferences(other.getPreferences());
            this.orgId(other.getOrgId());
            this.createdByUserId(other.getCreatedByUserId());
            this.createdAtTimestamp(other.getCreatedAtTimestamp());
            this.id(other.getId());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public OrgIdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="org_id")
        public CreatedByUserIdStage orgId(@NotNull String orgId) {
            this.orgId = Objects.requireNonNull(orgId, "orgId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_by_user_id")
        public CreatedAtTimestampStage createdByUserId(@NotNull String createdByUserId) {
            this.createdByUserId = Objects.requireNonNull(createdByUserId, "createdByUserId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at_timestamp")
        public IdStage createdAtTimestamp(@NotNull OffsetDateTime createdAtTimestamp) {
            this.createdAtTimestamp = Objects.requireNonNull(createdAtTimestamp, "createdAtTimestamp must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public _FinalStage preferences(Map<String, List<NotificationChannelEnum>> preferences) {
            this.preferences = Optional.ofNullable(preferences);
            return this;
        }

        @Override
        @JsonSetter(value="preferences", nulls=Nulls.SKIP)
        public _FinalStage preferences(Optional<Map<String, List<NotificationChannelEnum>>> preferences) {
            this.preferences = preferences;
            return this;
        }

        @Override
        public _FinalStage voicePhoneNumbers(List<String> voicePhoneNumbers) {
            this.voicePhoneNumbers = Optional.ofNullable(voicePhoneNumbers);
            return this;
        }

        @Override
        @JsonSetter(value="voice_phone_numbers", nulls=Nulls.SKIP)
        public _FinalStage voicePhoneNumbers(Optional<List<String>> voicePhoneNumbers) {
            this.voicePhoneNumbers = voicePhoneNumbers;
            return this;
        }

        @Override
        public _FinalStage smsPhoneNumbers(List<String> smsPhoneNumbers) {
            this.smsPhoneNumbers = Optional.ofNullable(smsPhoneNumbers);
            return this;
        }

        @Override
        @JsonSetter(value="sms_phone_numbers", nulls=Nulls.SKIP)
        public _FinalStage smsPhoneNumbers(Optional<List<String>> smsPhoneNumbers) {
            this.smsPhoneNumbers = smsPhoneNumbers;
            return this;
        }

        @Override
        public _FinalStage emailAddresses(List<String> emailAddresses) {
            this.emailAddresses = Optional.ofNullable(emailAddresses);
            return this;
        }

        @Override
        @JsonSetter(value="email_addresses", nulls=Nulls.SKIP)
        public _FinalStage emailAddresses(Optional<List<String>> emailAddresses) {
            this.emailAddresses = emailAddresses;
            return this;
        }

        @Override
        public ShipperNotificationPreferences1 build() {
            return new ShipperNotificationPreferences1(this.schemaVersion, this.emailAddresses, this.smsPhoneNumbers, this.voicePhoneNumbers, this.preferences, this.orgId, this.createdByUserId, this.createdAtTimestamp, this.id, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ShipperNotificationPreferences1 build();

        public _FinalStage emailAddresses(Optional<List<String>> var1);

        public _FinalStage emailAddresses(List<String> var1);

        public _FinalStage smsPhoneNumbers(Optional<List<String>> var1);

        public _FinalStage smsPhoneNumbers(List<String> var1);

        public _FinalStage voicePhoneNumbers(Optional<List<String>> var1);

        public _FinalStage voicePhoneNumbers(List<String> var1);

        public _FinalStage preferences(Optional<Map<String, List<NotificationChannelEnum>>> var1);

        public _FinalStage preferences(Map<String, List<NotificationChannelEnum>> var1);
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);
    }

    public static interface CreatedAtTimestampStage {
        public IdStage createdAtTimestamp(@NotNull OffsetDateTime var1);
    }

    public static interface CreatedByUserIdStage {
        public CreatedAtTimestampStage createdByUserId(@NotNull String var1);
    }

    public static interface OrgIdStage {
        public CreatedByUserIdStage orgId(@NotNull String var1);
    }

    public static interface SchemaVersionStage {
        public OrgIdStage schemaVersion(int var1);

        public Builder from(ShipperNotificationPreferences1 var1);
    }
}

