/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.LineItem1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ShipperPayCourierLineItemGroup1 {
    private final int schemaVersion;
    private final String taskGroupId;
    private final String courierOrgId;
    private final Optional<String> shipperOrgId;
    private final Optional<String> offChrtShipperOrgId;
    private final Optional<Boolean> orderCancelled;
    private final String rateSheetId;
    private final List<LineItem1> lineItems;
    private final String id;
    private final Map<String, Object> additionalProperties;

    private ShipperPayCourierLineItemGroup1(int schemaVersion, String taskGroupId, String courierOrgId, Optional<String> shipperOrgId, Optional<String> offChrtShipperOrgId, Optional<Boolean> orderCancelled, String rateSheetId, List<LineItem1> lineItems, String id, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.taskGroupId = taskGroupId;
        this.courierOrgId = courierOrgId;
        this.shipperOrgId = shipperOrgId;
        this.offChrtShipperOrgId = offChrtShipperOrgId;
        this.orderCancelled = orderCancelled;
        this.rateSheetId = rateSheetId;
        this.lineItems = lineItems;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="task_group_id")
    public String getTaskGroupId() {
        return this.taskGroupId;
    }

    @JsonProperty(value="courier_org_id")
    public String getCourierOrgId() {
        return this.courierOrgId;
    }

    @JsonIgnore
    public Optional<String> getShipperOrgId() {
        if (this.shipperOrgId == null) {
            return Optional.empty();
        }
        return this.shipperOrgId;
    }

    @JsonIgnore
    public Optional<String> getOffChrtShipperOrgId() {
        if (this.offChrtShipperOrgId == null) {
            return Optional.empty();
        }
        return this.offChrtShipperOrgId;
    }

    @JsonProperty(value="order_cancelled")
    public Optional<Boolean> getOrderCancelled() {
        return this.orderCancelled;
    }

    @JsonProperty(value="rate_sheet_id")
    public String getRateSheetId() {
        return this.rateSheetId;
    }

    @JsonProperty(value="line_items")
    public List<LineItem1> getLineItems() {
        return this.lineItems;
    }

    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="shipper_org_id")
    private Optional<String> _getShipperOrgId() {
        return this.shipperOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="off_chrt_shipper_org_id")
    private Optional<String> _getOffChrtShipperOrgId() {
        return this.offChrtShipperOrgId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ShipperPayCourierLineItemGroup1 && this.equalTo((ShipperPayCourierLineItemGroup1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ShipperPayCourierLineItemGroup1 other) {
        return this.schemaVersion == other.schemaVersion && this.taskGroupId.equals(other.taskGroupId) && this.courierOrgId.equals(other.courierOrgId) && this.shipperOrgId.equals(other.shipperOrgId) && this.offChrtShipperOrgId.equals(other.offChrtShipperOrgId) && this.orderCancelled.equals(other.orderCancelled) && this.rateSheetId.equals(other.rateSheetId) && this.lineItems.equals(other.lineItems) && this.id.equals(other.id);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.taskGroupId, this.courierOrgId, this.shipperOrgId, this.offChrtShipperOrgId, this.orderCancelled, this.rateSheetId, this.lineItems, this.id);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    TaskGroupIdStage,
    CourierOrgIdStage,
    RateSheetIdStage,
    IdStage,
    _FinalStage {
        private int schemaVersion;
        private String taskGroupId;
        private String courierOrgId;
        private String rateSheetId;
        private String id;
        private List<LineItem1> lineItems = new ArrayList<LineItem1>();
        private Optional<Boolean> orderCancelled = Optional.empty();
        private Optional<String> offChrtShipperOrgId = Optional.empty();
        private Optional<String> shipperOrgId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ShipperPayCourierLineItemGroup1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.taskGroupId(other.getTaskGroupId());
            this.courierOrgId(other.getCourierOrgId());
            this.shipperOrgId(other.getShipperOrgId());
            this.offChrtShipperOrgId(other.getOffChrtShipperOrgId());
            this.orderCancelled(other.getOrderCancelled());
            this.rateSheetId(other.getRateSheetId());
            this.lineItems(other.getLineItems());
            this.id(other.getId());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public TaskGroupIdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="task_group_id")
        public CourierOrgIdStage taskGroupId(@NotNull String taskGroupId) {
            this.taskGroupId = Objects.requireNonNull(taskGroupId, "taskGroupId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="courier_org_id")
        public RateSheetIdStage courierOrgId(@NotNull String courierOrgId) {
            this.courierOrgId = Objects.requireNonNull(courierOrgId, "courierOrgId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="rate_sheet_id")
        public IdStage rateSheetId(@NotNull String rateSheetId) {
            this.rateSheetId = Objects.requireNonNull(rateSheetId, "rateSheetId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllLineItems(List<LineItem1> lineItems) {
            if (lineItems != null) {
                this.lineItems.addAll(lineItems);
            }
            return this;
        }

        @Override
        public _FinalStage addLineItems(LineItem1 lineItems) {
            this.lineItems.add(lineItems);
            return this;
        }

        @Override
        @JsonSetter(value="line_items", nulls=Nulls.SKIP)
        public _FinalStage lineItems(List<LineItem1> lineItems) {
            this.lineItems.clear();
            if (lineItems != null) {
                this.lineItems.addAll(lineItems);
            }
            return this;
        }

        @Override
        public _FinalStage orderCancelled(Boolean orderCancelled) {
            this.orderCancelled = Optional.ofNullable(orderCancelled);
            return this;
        }

        @Override
        @JsonSetter(value="order_cancelled", nulls=Nulls.SKIP)
        public _FinalStage orderCancelled(Optional<Boolean> orderCancelled) {
            this.orderCancelled = orderCancelled;
            return this;
        }

        @Override
        public _FinalStage offChrtShipperOrgId(Nullable<String> offChrtShipperOrgId) {
            this.offChrtShipperOrgId = offChrtShipperOrgId.isNull() ? null : (offChrtShipperOrgId.isEmpty() ? Optional.empty() : Optional.of(offChrtShipperOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage offChrtShipperOrgId(String offChrtShipperOrgId) {
            this.offChrtShipperOrgId = Optional.ofNullable(offChrtShipperOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="off_chrt_shipper_org_id", nulls=Nulls.SKIP)
        public _FinalStage offChrtShipperOrgId(Optional<String> offChrtShipperOrgId) {
            this.offChrtShipperOrgId = offChrtShipperOrgId;
            return this;
        }

        @Override
        public _FinalStage shipperOrgId(Nullable<String> shipperOrgId) {
            this.shipperOrgId = shipperOrgId.isNull() ? null : (shipperOrgId.isEmpty() ? Optional.empty() : Optional.of(shipperOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage shipperOrgId(String shipperOrgId) {
            this.shipperOrgId = Optional.ofNullable(shipperOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="shipper_org_id", nulls=Nulls.SKIP)
        public _FinalStage shipperOrgId(Optional<String> shipperOrgId) {
            this.shipperOrgId = shipperOrgId;
            return this;
        }

        @Override
        public ShipperPayCourierLineItemGroup1 build() {
            return new ShipperPayCourierLineItemGroup1(this.schemaVersion, this.taskGroupId, this.courierOrgId, this.shipperOrgId, this.offChrtShipperOrgId, this.orderCancelled, this.rateSheetId, this.lineItems, this.id, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ShipperPayCourierLineItemGroup1 build();

        public _FinalStage shipperOrgId(Optional<String> var1);

        public _FinalStage shipperOrgId(String var1);

        public _FinalStage shipperOrgId(Nullable<String> var1);

        public _FinalStage offChrtShipperOrgId(Optional<String> var1);

        public _FinalStage offChrtShipperOrgId(String var1);

        public _FinalStage offChrtShipperOrgId(Nullable<String> var1);

        public _FinalStage orderCancelled(Optional<Boolean> var1);

        public _FinalStage orderCancelled(Boolean var1);

        public _FinalStage lineItems(List<LineItem1> var1);

        public _FinalStage addLineItems(LineItem1 var1);

        public _FinalStage addAllLineItems(List<LineItem1> var1);
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);
    }

    public static interface RateSheetIdStage {
        public IdStage rateSheetId(@NotNull String var1);
    }

    public static interface CourierOrgIdStage {
        public RateSheetIdStage courierOrgId(@NotNull String var1);
    }

    public static interface TaskGroupIdStage {
        public CourierOrgIdStage taskGroupId(@NotNull String var1);
    }

    public static interface SchemaVersionStage {
        public TaskGroupIdStage schemaVersion(int var1);

        public Builder from(ShipperPayCourierLineItemGroup1 var1);
    }
}

